/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.standard;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.JpfException;
import org.java.plugin.PathResolver;
import org.java.plugin.Plugin;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginLifecycleException;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.registry.PluginPrerequisite;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.standard.PluginLifecycleHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StandardPluginManager
extends PluginManager {
    Log log = LogFactory.getLog(this.getClass());
    private final PathResolver pathResolver;
    private final PluginRegistry registry;
    private final PluginLifecycleHandler lifecycleHandler;
    private final Map<String, Plugin> activePlugins = new HashMap<String, Plugin>();
    private final Set<String> activatingPlugins = new HashSet<String>();
    private final Set<String> badPlugins = new HashSet<String>();
    private final List<String> activationLog = new LinkedList<String>();
    private final Map<String, PluginClassLoader> classLoaders = new HashMap<String, PluginClassLoader>();
    private final Set<String> disabledPlugins = new HashSet<String>();
    private final List<PluginManager.EventListener> listeners = Collections.synchronizedList(new LinkedList());
    private PluginRegistry.RegistryChangeListener registryChangeListener;
    private Map<String, URL> notRegisteredPluginLocations = new HashMap<String, URL>();

    protected StandardPluginManager(PluginRegistry aRegistry, PathResolver aPathResolver, PluginLifecycleHandler aLifecycleHandler) {
        this.registry = aRegistry;
        this.pathResolver = aPathResolver;
        this.lifecycleHandler = aLifecycleHandler;
        this.lifecycleHandler.init(this);
        this.registryChangeListener = new PluginRegistry.RegistryChangeListener(){

            public void registryChanged(PluginRegistry.RegistryChangeData data) {
                StandardPluginManager.this.registryChangeHandler(data);
            }
        };
        this.registry.registerListener(this.registryChangeListener);
    }

    @Override
    public PluginRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public PathResolver getPathResolver() {
        return this.pathResolver;
    }

    synchronized void registryChangeHandler(PluginRegistry.RegistryChangeData data) {
        URL location;
        this.badPlugins.clear();
        for (String id : data.removedPlugins()) {
            this.deactivatePlugin(id);
            this.pathResolver.unregisterContext(id);
        }
        for (PluginDescriptor pluginDescriptor : this.registry.getPluginDescriptors()) {
            location = this.notRegisteredPluginLocations.remove(pluginDescriptor.getLocation().toExternalForm());
            if (location == null) continue;
            this.pathResolver.registerContext(pluginDescriptor, location);
        }
        for (PluginFragment pluginFragment : this.registry.getPluginFragments()) {
            location = this.notRegisteredPluginLocations.remove(pluginFragment.getLocation().toExternalForm());
            if (location == null) continue;
            this.pathResolver.registerContext(pluginFragment, location);
        }
        for (String string : data.modifiedPlugins()) {
            if (this.activePlugins.containsKey(string)) {
                this.deactivatePlugin(string);
                try {
                    this.activatePlugin(string);
                }
                catch (Exception e) {
                    this.log.error((Object)("failed activating modified plug-in " + string), (Throwable)e);
                }
                continue;
            }
            PluginClassLoader clsLoader = this.classLoaders.get(string);
            if (clsLoader == null) continue;
            this.notifyClassLoader(clsLoader);
        }
    }

    @Override
    public Map<String, Identity> publishPlugins(PluginManager.PluginLocation[] locations) throws JpfException {
        LinkedList<URL> manifests = new LinkedList<URL>();
        for (PluginManager.PluginLocation location : locations) {
            URL manifest = location.getManifestLocation();
            manifests.add(manifest);
            this.notRegisteredPluginLocations.put(manifest.toExternalForm(), location.getContextLocation());
        }
        return this.registry.register(manifests.toArray(new URL[manifests.size()]));
    }

    @Override
    public Plugin getPlugin(String id) throws PluginLifecycleException {
        Plugin result = this.activePlugins.get(id);
        if (result != null) {
            return result;
        }
        if (this.badPlugins.contains(id)) {
            throw new IllegalArgumentException("plug-in " + id + " disabled internally as it wasn't properly initialized");
        }
        if (this.disabledPlugins.contains(id)) {
            throw new IllegalArgumentException("plug-in " + id + " disabled externally");
        }
        PluginDescriptor descr = this.registry.getPluginDescriptor(id);
        if (descr == null) {
            throw new IllegalArgumentException("unknown plug-in ID - " + id);
        }
        return this.activatePlugin(descr);
    }

    @Override
    public void activatePlugin(String id) throws PluginLifecycleException {
        if (this.activePlugins.containsKey(id)) {
            return;
        }
        if (this.badPlugins.contains(id)) {
            throw new IllegalArgumentException("plug-in " + id + " disabled internally as it wasn't properly initialized");
        }
        if (this.disabledPlugins.contains(id)) {
            throw new IllegalArgumentException("plug-in " + id + " disabled externally");
        }
        PluginDescriptor descr = this.registry.getPluginDescriptor(id);
        if (descr == null) {
            throw new IllegalArgumentException("unknown plug-in ID - " + id);
        }
        this.activatePlugin(descr);
    }

    @Override
    public Plugin getPluginFor(Object obj) {
        if (obj == null) {
            return null;
        }
        ClassLoader clsLoader = obj instanceof Class ? ((Class)obj).getClassLoader() : (obj instanceof ClassLoader ? (ClassLoader)obj : obj.getClass().getClassLoader());
        if (!(clsLoader instanceof PluginClassLoader)) {
            return null;
        }
        PluginDescriptor descr = ((PluginClassLoader)clsLoader).getPluginDescriptor();
        Plugin result = this.activePlugins.get(descr.getId());
        if (result != null) {
            return result;
        }
        throw new IllegalStateException("can't get plug-in " + descr);
    }

    @Override
    public boolean isPluginActivated(PluginDescriptor descr) {
        return this.activePlugins.containsKey(descr.getId());
    }

    @Override
    public boolean isBadPlugin(PluginDescriptor descr) {
        return this.badPlugins.contains(descr.getId());
    }

    @Override
    public boolean isPluginActivating(PluginDescriptor descr) {
        return this.activatingPlugins.contains(descr.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PluginClassLoader getPluginClassLoader(PluginDescriptor descr) {
        if (this.badPlugins.contains(descr.getId())) {
            throw new IllegalArgumentException("plug-in " + descr.getId() + " disabled internally as it wasn't properly initialized");
        }
        if (this.disabledPlugins.contains(descr.getId())) {
            throw new IllegalArgumentException("plug-in " + descr.getId() + " disabled externally");
        }
        PluginClassLoader result = this.classLoaders.get(descr.getId());
        if (result != null) {
            return result;
        }
        StandardPluginManager standardPluginManager = this;
        synchronized (standardPluginManager) {
            result = this.classLoaders.get(descr.getId());
            if (result != null) {
                return result;
            }
            result = this.lifecycleHandler.createPluginClassLoader(descr);
            this.classLoaders.put(descr.getId(), result);
        }
        return result;
    }

    @Override
    public synchronized void shutdown() {
        this.log.debug((Object)"shutting down...");
        this.dump();
        this.registry.unregisterListener(this.registryChangeListener);
        ArrayList<String> reversedLog = new ArrayList<String>(this.activationLog);
        Collections.reverse(reversedLog);
        for (String id : reversedLog) {
            PluginDescriptor descr = this.registry.getPluginDescriptor(id);
            if (descr == null) {
                this.log.warn((Object)("can't find descriptor for plug-in " + id + " to deactivate plug-in"), (Throwable)new Exception("fake exception to view stack trace"));
                continue;
            }
            this.deactivatePlugin(descr);
        }
        this.dump();
        this.classLoaders.clear();
        this.disabledPlugins.clear();
        this.listeners.clear();
        this.lifecycleHandler.dispose();
        this.log.info((Object)"shutdown done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Plugin activatePlugin(PluginDescriptor descr) throws PluginLifecycleException {
        Plugin result = this.activePlugins.get(descr.getId());
        if (result != null) {
            return result;
        }
        if (this.badPlugins.contains(descr.getId())) {
            throw new IllegalArgumentException("plug-in " + descr.getId() + " disabled as it wasn't properly initialized");
        }
        if (this.activatingPlugins.contains(descr.getId())) {
            throw new PluginLifecycleException("org.java.plugin.standard", "pluginActivating", descr.getId());
        }
        this.activatingPlugins.add(descr.getId());
        try {
            try {
                this.checkPrerequisites(descr);
                String pluginClassName = descr.getPluginClassName();
                result = pluginClassName == null || pluginClassName.trim().length() == 0 ? new EmptyPlugin() : this.lifecycleHandler.createPluginInstance(descr);
                this.initPlugin(result, descr);
                this.lifecycleHandler.beforePluginStart(result);
                this.startPlugin(result);
            }
            catch (PluginLifecycleException ple) {
                this.badPlugins.add(descr.getId());
                this.classLoaders.remove(descr.getId());
                throw ple;
            }
            catch (Exception e) {
                this.badPlugins.add(descr.getId());
                this.classLoaders.remove(descr.getId());
                throw new PluginLifecycleException("org.java.plugin.standard", "pluginStartFailed", descr.getUniqueId(), e);
            }
            this.activePlugins.put(descr.getId(), result);
            this.activationLog.add(descr.getId());
            this.log.info((Object)("plug-in started - " + descr.getUniqueId()));
            this.fireEvent(result, true);
            Plugin plugin = result;
            return plugin;
        }
        finally {
            this.activatingPlugins.remove(descr.getId());
        }
    }

    private void checkPrerequisites(PluginDescriptor descr) throws PluginLifecycleException {
        for (PluginPrerequisite pre : descr.getPrerequisites()) {
            if (this.activatingPlugins.contains(pre.getPluginId())) {
                this.log.warn((Object)("dependencies loop detected during activation of plug-in " + descr), (Throwable)new Exception("fake exception to view stack trace"));
                continue;
            }
            if (this.badPlugins.contains(pre.getPluginId())) {
                if (pre.isOptional()) continue;
                throw new PluginLifecycleException("org.java.plugin.standard", "pluginPrerequisiteBad", new Object[]{descr.getId(), pre.getPluginId()});
            }
            if (this.disabledPlugins.contains(pre.getPluginId())) {
                if (pre.isOptional()) continue;
                throw new PluginLifecycleException("org.java.plugin.standard", "pluginPrerequisiteDisabled", new Object[]{descr.getId(), pre.getPluginId()});
            }
            if (!pre.matches()) {
                if (pre.isOptional()) continue;
                throw new PluginLifecycleException("org.java.plugin.standard", "pluginPrerequisiteNotMatches", new Object[]{descr.getId(), pre.getPluginId()});
            }
            try {
                this.activatePlugin(this.registry.getPluginDescriptor(pre.getPluginId()));
            }
            catch (PluginLifecycleException ple) {
                if (pre.isOptional()) {
                    this.log.warn((Object)("failed activating optional plug-in from prerequisite " + pre), (Throwable)ple);
                    continue;
                }
                throw ple;
            }
        }
    }

    @Override
    public void deactivatePlugin(String id) {
        if (!this.activePlugins.containsKey(id)) {
            return;
        }
        PluginDescriptor descr = this.registry.getPluginDescriptor(id);
        if (descr == null) {
            throw new IllegalArgumentException("unknown plug-in ID - " + id);
        }
        HashMap<String, PluginDescriptor> dependingPluginsMap = new HashMap<String, PluginDescriptor>();
        for (PluginDescriptor dependingPlugin : this.registry.getDependingPlugins(descr)) {
            dependingPluginsMap.put(dependingPlugin.getId(), dependingPlugin);
        }
        LinkedList<PluginDescriptor> tobeDeactivated = new LinkedList<PluginDescriptor>();
        ArrayList<String> reversedLog = new ArrayList<String>(this.activationLog);
        Collections.reverse(reversedLog);
        for (String pluginId : reversedLog) {
            if (pluginId.equals(descr.getId())) {
                tobeDeactivated.add(descr);
                continue;
            }
            if (!dependingPluginsMap.containsKey(pluginId)) continue;
            tobeDeactivated.add((PluginDescriptor)dependingPluginsMap.get(pluginId));
        }
        for (PluginDescriptor descriptor : tobeDeactivated) {
            this.deactivatePlugin(descriptor);
        }
        this.dump();
    }

    private synchronized void deactivatePlugin(PluginDescriptor descr) {
        PluginClassLoader clsLoader;
        Plugin plugin = this.activePlugins.remove(descr.getId());
        if (plugin != null) {
            try {
                if (plugin.isActive()) {
                    this.fireEvent(plugin, false);
                    this.stopPlugin(plugin);
                    this.lifecycleHandler.afterPluginStop(plugin);
                    this.log.info((Object)("plug-in stopped - " + descr.getUniqueId()));
                } else {
                    this.log.warn((Object)("plug-in " + descr.getUniqueId() + " is not active although present in active " + "plug-ins list"), (Throwable)new Exception("fake exception to view stack trace"));
                }
            }
            catch (Exception e) {
                this.log.error((Object)("error while stopping plug-in " + descr.getUniqueId()), (Throwable)e);
            }
        }
        if ((clsLoader = this.classLoaders.remove(descr.getId())) != null) {
            this.disposeClassLoader(clsLoader);
        }
        this.badPlugins.remove(descr.getId());
        this.activationLog.remove(descr.getId());
    }

    private void dump() {
        if (!this.log.isDebugEnabled()) {
            return;
        }
        StringBuilder buf = new StringBuilder("PLUGIN MANAGER DUMP:\r\n");
        buf.append("-------------- DUMP BEGIN -----------------\r\n");
        buf.append("\tActive plug-ins: " + this.activePlugins.size()).append("\r\n");
        for (Plugin plugin : this.activePlugins.values()) {
            buf.append("\t\t").append(plugin).append("\r\n");
        }
        buf.append("\tActivating plug-ins: " + this.activatingPlugins.size()).append("\r\n");
        for (String s : this.activatingPlugins) {
            buf.append("\t\t").append(s).append("\r\n");
        }
        buf.append("\tPlug-ins with instantiated class loaders: " + this.classLoaders.size()).append("\r\n");
        for (String s : this.classLoaders.keySet()) {
            buf.append("\t\t").append(s).append("\r\n");
        }
        buf.append("\tDisabled plug-ins: " + this.disabledPlugins.size()).append("\r\n");
        for (String s : this.disabledPlugins) {
            buf.append("\t\t").append(s).append("\r\n");
        }
        buf.append("\tBad plug-ins: " + this.badPlugins.size()).append("\r\n");
        for (String s : this.badPlugins) {
            buf.append("\t\t").append(s).append("\r\n");
        }
        buf.append("\tActivation log: " + this.activationLog.size()).append("\r\n");
        for (String s : this.activationLog) {
            buf.append("\t\t").append(s).append("\r\n");
        }
        buf.append("Memory TOTAL/FREE/MAX: ").append(Runtime.getRuntime().totalMemory()).append("/").append(Runtime.getRuntime().freeMemory()).append("/").append(Runtime.getRuntime().maxMemory()).append("\r\n");
        buf.append("-------------- DUMP END -----------------");
        this.log.debug((Object)buf.toString());
    }

    @Override
    public PluginDescriptor[] disablePlugin(PluginDescriptor descr) {
        LinkedList<PluginDescriptor> result = new LinkedList<PluginDescriptor>();
        if (!this.disabledPlugins.contains(descr.getId())) {
            this.deactivatePlugin(descr);
            this.fireEvent(descr, false);
            this.disabledPlugins.add(descr.getId());
            result.add(descr);
        }
        for (PluginDescriptor dependedPlugin : this.registry.getDependingPlugins(descr)) {
            if (this.disabledPlugins.contains(dependedPlugin.getId())) continue;
            this.deactivatePlugin(dependedPlugin);
            this.fireEvent(dependedPlugin, false);
            this.disabledPlugins.add(dependedPlugin.getId());
            result.add(dependedPlugin);
        }
        return result.toArray(new PluginDescriptor[result.size()]);
    }

    @Override
    public PluginDescriptor[] enablePlugin(PluginDescriptor descr, boolean includeDependings) {
        LinkedList<PluginDescriptor> result = new LinkedList<PluginDescriptor>();
        if (this.disabledPlugins.contains(descr.getId())) {
            this.disabledPlugins.remove(descr.getId());
            this.fireEvent(descr, true);
            result.add(descr);
        }
        if (includeDependings) {
            for (PluginDescriptor dependedPlugin : this.registry.getDependingPlugins(descr)) {
                if (!this.disabledPlugins.contains(dependedPlugin.getId())) continue;
                this.disabledPlugins.remove(dependedPlugin.getId());
                this.fireEvent(dependedPlugin, true);
                result.add(dependedPlugin);
            }
        }
        return result.toArray(new PluginDescriptor[result.size()]);
    }

    @Override
    public boolean isPluginEnabled(PluginDescriptor descr) {
        return !this.disabledPlugins.contains(descr.getId());
    }

    @Override
    public void registerListener(PluginManager.EventListener listener) {
        if (this.listeners.contains(listener)) {
            throw new IllegalArgumentException("listener " + listener + " already registered");
        }
        this.listeners.add(listener);
    }

    @Override
    public void unregisterListener(PluginManager.EventListener listener) {
        if (!this.listeners.remove(listener)) {
            this.log.warn((Object)("unknown listener " + listener));
        }
    }

    private void fireEvent(Object data, boolean on) {
        if (this.listeners.isEmpty()) {
            return;
        }
        PluginManager.EventListener[] arr = this.listeners.toArray(new PluginManager.EventListener[this.listeners.size()]);
        if (data instanceof PluginDescriptor) {
            PluginDescriptor descr = (PluginDescriptor)data;
            if (on) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("propagating \"pluginEnabled\" event for " + descr));
                }
                for (PluginManager.EventListener element : arr) {
                    element.pluginEnabled(descr);
                }
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("propagating \"pluginDisabled\" event for " + descr));
                }
                for (PluginManager.EventListener element : arr) {
                    element.pluginDisabled(descr);
                }
            }
        } else {
            Plugin plugin = (Plugin)data;
            if (on) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("propagating \"pluginActivated\" event for " + plugin));
                }
                for (PluginManager.EventListener element : arr) {
                    element.pluginActivated(plugin);
                }
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("propagating \"pluginDeactivated\" event for " + plugin));
                }
                for (PluginManager.EventListener element : arr) {
                    element.pluginDeactivated(plugin);
                }
            }
        }
    }

    static final class EmptyPlugin
    extends Plugin {
        EmptyPlugin() {
        }

        protected void doStart() throws Exception {
        }

        protected void doStop() throws Exception {
        }
    }
}

