/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.standard;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.PathResolver;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Library;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginPrerequisite;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.util.IoUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardPluginClassLoader
extends PluginClassLoader {
    static Log log = LogFactory.getLog(StandardPluginClassLoader.class);
    private static File libCacheFolder;
    private static boolean libCacheFolderInitialized;
    private PluginDescriptor[] publicImports;
    private PluginDescriptor[] privateImports;
    private PluginDescriptor[] reverseLookups;
    private PluginResourceLoader resourceLoader;
    private Map<String, ResourceFilter> resourceFilters;
    private Map<String, File> libraryCache;
    private boolean probeParentLoaderLast;

    private static URL getClassBaseUrl(Class<?> cls) {
        CodeSource cs;
        ProtectionDomain pd = cls.getProtectionDomain();
        if (pd != null && (cs = pd.getCodeSource()) != null) {
            return cs.getLocation();
        }
        return null;
    }

    private static URL[] getUrls(PluginManager manager, PluginDescriptor descr) {
        LinkedList<URL> result = new LinkedList<URL>();
        for (Library lib : descr.getLibraries()) {
            if (!lib.isCodeLibrary()) continue;
            result.add(manager.getPathResolver().resolvePath(lib, lib.getPath()));
        }
        if (log.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder();
            buf.append("Code URL's populated for plug-in " + descr + ":\r\n");
            for (URL element : result) {
                buf.append("\t");
                buf.append(element);
                buf.append("\r\n");
            }
            log.debug((Object)buf.toString());
        }
        return result.toArray(new URL[result.size()]);
    }

    private static URL[] getUrls(PluginManager manager, PluginDescriptor descr, URL[] existingUrls) {
        List<URL> urls = Arrays.asList(existingUrls);
        LinkedList<URL> result = new LinkedList<URL>();
        for (Library lib : descr.getLibraries()) {
            URL url;
            if (!lib.isCodeLibrary() || urls.contains(url = manager.getPathResolver().resolvePath(lib, lib.getPath()))) continue;
            result.add(url);
        }
        return result.toArray(new URL[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getLibCacheFolder() {
        if (libCacheFolder != null) {
            return libCacheFolderInitialized ? libCacheFolder : null;
        }
        Class<StandardPluginClassLoader> clazz = StandardPluginClassLoader.class;
        synchronized (StandardPluginClassLoader.class) {
            libCacheFolder = new File(System.getProperty("java.io.tmpdir"), System.currentTimeMillis() + ".jpf-lib-cache");
            log.debug((Object)("libraries cache folder is " + libCacheFolder));
            File lockFile = new File(libCacheFolder, "lock");
            if (lockFile.exists()) {
                log.error((Object)("can't initialize libraries cache folder " + libCacheFolder + " as lock file indicates that it" + " is owned by another JPF instance"));
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            if (libCacheFolder.exists()) {
                IoUtil.emptyFolder(libCacheFolder);
            } else {
                libCacheFolder.mkdirs();
            }
            try {
                if (!lockFile.createNewFile()) {
                    log.error((Object)("can't create lock file in JPF libraries cache folder " + libCacheFolder));
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return null;
                }
            }
            catch (IOException ioe) {
                log.error((Object)("can't create lock file in JPF libraries cache folder " + libCacheFolder), (Throwable)ioe);
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            lockFile.deleteOnExit();
            libCacheFolder.deleteOnExit();
            libCacheFolderInitialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return libCacheFolder;
        }
    }

    public StandardPluginClassLoader(PluginManager aManager, PluginDescriptor descr, ClassLoader parent) {
        super(aManager, descr, StandardPluginClassLoader.getUrls(aManager, descr), parent);
        this.collectImports();
        this.resourceLoader = PluginResourceLoader.get(aManager, descr);
        this.collectFilters();
        this.libraryCache = new HashMap<String, File>();
    }

    protected void collectImports() {
        HashMap<String, PluginDescriptor> publicImportsMap = new HashMap<String, PluginDescriptor>();
        HashMap<String, PluginDescriptor> privateImportsMap = new HashMap<String, PluginDescriptor>();
        PluginRegistry registry = this.getPluginDescriptor().getRegistry();
        for (PluginPrerequisite pre : this.getPluginDescriptor().getPrerequisites()) {
            if (!pre.matches()) continue;
            PluginDescriptor preDescr = registry.getPluginDescriptor(pre.getPluginId());
            if (pre.isExported()) {
                publicImportsMap.put(preDescr.getId(), preDescr);
                continue;
            }
            privateImportsMap.put(preDescr.getId(), preDescr);
        }
        this.publicImports = publicImportsMap.values().toArray(new PluginDescriptor[publicImportsMap.size()]);
        this.privateImports = privateImportsMap.values().toArray(new PluginDescriptor[privateImportsMap.size()]);
        HashMap<String, PluginDescriptor> reverseLookupsMap = new HashMap<String, PluginDescriptor>();
        block1: for (PluginDescriptor descr : registry.getPluginDescriptors()) {
            if (descr.equals(this.getPluginDescriptor()) || publicImportsMap.containsKey(descr.getId()) || privateImportsMap.containsKey(descr.getId())) continue;
            for (PluginPrerequisite pre : descr.getPrerequisites()) {
                if (!pre.getPluginId().equals(this.getPluginDescriptor().getId()) || !pre.isReverseLookup() || !pre.matches()) continue;
                reverseLookupsMap.put(descr.getId(), descr);
                continue block1;
            }
        }
        this.reverseLookups = reverseLookupsMap.values().toArray(new PluginDescriptor[reverseLookupsMap.size()]);
    }

    protected void collectFilters() {
        if (this.resourceFilters == null) {
            this.resourceFilters = new HashMap<String, ResourceFilter>();
        } else {
            this.resourceFilters.clear();
        }
        for (Library lib : this.getPluginDescriptor().getLibraries()) {
            this.resourceFilters.put(this.getPluginManager().getPathResolver().resolvePath(lib, lib.getPath()).toExternalForm(), new ResourceFilter(lib));
        }
    }

    @Override
    protected void pluginsSetChanged() {
        URL[] newUrls;
        for (URL element : newUrls = StandardPluginClassLoader.getUrls(this.getPluginManager(), this.getPluginDescriptor(), this.getURLs())) {
            this.addURL(element);
        }
        if (log.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder();
            buf.append("New code URL's populated for plug-in " + this.getPluginDescriptor() + ":\r\n");
            for (URL element : newUrls) {
                buf.append("\t");
                buf.append(element);
                buf.append("\r\n");
            }
            log.debug((Object)buf.toString());
        }
        this.collectImports();
        this.resourceLoader = PluginResourceLoader.get(this.getPluginManager(), this.getPluginDescriptor());
        this.collectFilters();
        Set<Map.Entry<String, File>> entrySet = this.libraryCache.entrySet();
        Iterator<Map.Entry<String, File>> it = entrySet.iterator();
        while (it.hasNext()) {
            if (it.next().getValue() != null) continue;
            it.remove();
        }
    }

    @Override
    protected void dispose() {
        for (File file : this.libraryCache.values()) {
            file.delete();
        }
        this.libraryCache.clear();
        this.resourceFilters.clear();
        this.privateImports = null;
        this.publicImports = null;
        this.resourceLoader = null;
    }

    protected void setProbeParentLoaderLast(boolean value) {
        this.probeParentLoaderLast = value;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result;
        if (this.probeParentLoaderLast) {
            try {
                result = this.loadClass(name, resolve, this, null);
            }
            catch (ClassNotFoundException cnfe) {
                result = this.getParent().loadClass(name);
            }
            if (result == null) {
                result = this.getParent().loadClass(name);
            }
        } else {
            try {
                result = this.getParent().loadClass(name);
            }
            catch (ClassNotFoundException cnfe) {
                result = this.loadClass(name, resolve, this, null);
            }
        }
        if (result != null) {
            return result;
        }
        throw new ClassNotFoundException(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> loadClass(String name, boolean resolve, StandardPluginClassLoader requestor, Set<String> seenPlugins) throws ClassNotFoundException {
        Set<String> seen = seenPlugins;
        if (seen != null && seen.contains(this.getPluginDescriptor().getId())) {
            return null;
        }
        if (this != requestor && !this.getPluginManager().isPluginActivated(this.getPluginDescriptor()) && !this.getPluginManager().isPluginActivating(this.getPluginDescriptor())) {
            String msg = "can't load class " + name + ", plug-in " + this.getPluginDescriptor() + " is not activated yet";
            log.warn((Object)msg);
            throw new ClassNotFoundException(msg);
        }
        Class<?> result = null;
        boolean debugEnabled = log.isDebugEnabled();
        StandardPluginClassLoader standardPluginClassLoader = this;
        synchronized (standardPluginClassLoader) {
            result = this.findLoadedClass(name);
            if (result != null) {
                if (debugEnabled) {
                    log.debug((Object)("loadClass(...): found loaded class, class=" + result + ", this=" + this + ", requestor=" + requestor));
                }
                this.checkClassVisibility(result, requestor);
                return result;
            }
            try {
                result = this.findClass(name);
            }
            catch (LinkageError le) {
                if (debugEnabled) {
                    log.debug((Object)("loadClass(...): class loading failed, name=" + name + ", this=" + this + ", requestor=" + requestor), (Throwable)le);
                }
                throw le;
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
            if (result != null) {
                if (debugEnabled) {
                    log.debug((Object)("loadClass(...): found class, class=" + result + ", this=" + this + ", requestor=" + requestor));
                }
                this.checkClassVisibility(result, requestor);
                if (resolve) {
                    this.resolveClass(result);
                }
                return result;
            }
        }
        if (seen == null) {
            seen = new HashSet<String>();
        }
        if (debugEnabled) {
            log.debug((Object)("loadClass(...): class not found, name=" + name + ", this=" + this + ", requestor=" + requestor));
        }
        seen.add(this.getPluginDescriptor().getId());
        for (PluginDescriptor element : this.publicImports) {
            if (!seen.contains(element.getId()) && (result = ((StandardPluginClassLoader)this.getPluginManager().getPluginClassLoader(element)).loadClass(name, resolve, requestor, seen)) != null) break;
        }
        if (this == requestor && result == null) {
            for (PluginDescriptor element : this.privateImports) {
                if (!seen.contains(element.getId()) && (result = ((StandardPluginClassLoader)this.getPluginManager().getPluginClassLoader(element)).loadClass(name, resolve, requestor, seen)) != null) break;
            }
        }
        if (result == null) {
            for (PluginDescriptor descr : this.reverseLookups) {
                if (!seen.contains(descr.getId()) && (this.getPluginManager().isPluginActivated(descr) || this.getPluginManager().isPluginActivating(descr)) && (result = ((StandardPluginClassLoader)this.getPluginManager().getPluginClassLoader(descr)).loadClass(name, resolve, requestor, seen)) != null) break;
            }
        }
        return result;
    }

    protected void checkClassVisibility(Class<?> cls, StandardPluginClassLoader requestor) throws ClassNotFoundException {
        if (this == requestor) {
            return;
        }
        URL lib = StandardPluginClassLoader.getClassBaseUrl(cls);
        if (lib == null) {
            return;
        }
        ClassLoader loader = cls.getClassLoader();
        if (!(loader instanceof StandardPluginClassLoader)) {
            return;
        }
        if (loader != this) {
            ((StandardPluginClassLoader)loader).checkClassVisibility(cls, requestor);
        } else {
            ResourceFilter filter = this.resourceFilters.get(lib.toExternalForm());
            if (filter == null) {
                log.warn((Object)("class not visible, no class filter found, lib=" + lib + ", class=" + cls + ", this=" + this + ", requestor=" + requestor));
                throw new ClassNotFoundException("class " + cls.getName() + " is not visible for plug-in " + requestor.getPluginDescriptor().getId() + ", no filter found for library " + lib);
            }
            if (!filter.isClassVisible(cls.getName())) {
                log.warn((Object)("class not visible, lib=" + lib + ", class=" + cls + ", this=" + this + ", requestor=" + requestor));
                throw new ClassNotFoundException("class " + cls.getName() + " is not visible for plug-in " + requestor.getPluginDescriptor().getId());
            }
        }
    }

    @Override
    protected String findLibrary(String name) {
        if (name == null || "".equals(name.trim())) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("findLibrary(String): name=" + name + ", this=" + this));
        }
        String libname = System.mapLibraryName(name);
        String result = null;
        PathResolver pathResolver = this.getPluginManager().getPathResolver();
        for (Library lib : this.getPluginDescriptor().getLibraries()) {
            File libFile;
            if (lib.isCodeLibrary()) continue;
            URL libUrl = pathResolver.resolvePath(lib, lib.getPath() + libname);
            if (log.isDebugEnabled()) {
                log.debug((Object)("findLibrary(String): trying URL " + libUrl));
            }
            if ((libFile = IoUtil.url2file(libUrl)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("findLibrary(String): URL " + libUrl + " resolved as local file " + libFile));
                }
                if (!libFile.isFile()) continue;
                result = libFile.getAbsolutePath();
                break;
            }
            String libraryCacheKey = libUrl.toExternalForm();
            libFile = this.libraryCache.get(libraryCacheKey);
            if (libFile != null) {
                if (libFile.isFile()) {
                    result = libFile.getAbsolutePath();
                    break;
                }
                this.libraryCache.remove(libraryCacheKey);
            }
            if (this.libraryCache.containsKey(libraryCacheKey)) break;
            libFile = this.cacheLibrary(libUrl, libname);
            if (libFile == null) continue;
            result = libFile.getAbsolutePath();
            break;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("findLibrary(String): name=" + name + ", libname=" + libname + ", result=" + result + ", this=" + this));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized File cacheLibrary(URL libUrl, String libname) {
        String libraryCacheKey = libUrl.toExternalForm();
        File result = this.libraryCache.get(libraryCacheKey);
        if (result != null) {
            return result;
        }
        try {
            File cacheFolder = StandardPluginClassLoader.getLibCacheFolder();
            if (cacheFolder == null) {
                throw new IOException("can't initialize libraries cache folder");
            }
            File libCachePluginFolder = new File(cacheFolder, this.getPluginDescriptor().getUniqueId());
            if (!libCachePluginFolder.exists() && !libCachePluginFolder.mkdirs()) {
                throw new IOException("can't create cache folder " + libCachePluginFolder);
            }
            result = new File(libCachePluginFolder, libname);
            InputStream in = IoUtil.getResourceInputStream(libUrl);
            try {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(result));
                try {
                    IoUtil.copyStream(in, out, 512);
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
            finally {
                in.close();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("library " + libname + " successfully cached from URL " + libUrl + " and saved to local file " + result));
            }
        }
        catch (IOException ioe) {
            log.error((Object)("can't cache library " + libname + " from URL " + libUrl), (Throwable)ioe);
            result = null;
        }
        this.libraryCache.put(libraryCacheKey, result);
        return result;
    }

    @Override
    public URL findResource(String name) {
        URL result = this.findResource(name, this, null);
        return result;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        LinkedList<URL> result = new LinkedList<URL>();
        this.findResources(result, name, this, null);
        return Collections.enumeration(result);
    }

    protected URL findResource(String name, StandardPluginClassLoader requestor, Set<String> seenPlugins) {
        Set<String> seen = seenPlugins;
        if (seen != null && seen.contains(this.getPluginDescriptor().getId())) {
            return null;
        }
        URL result = super.findResource(name);
        if (result != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("findResource(...): resource found in classpath, name=" + name + " URL=" + result + ", this=" + this + ", requestor=" + requestor));
            }
            if (this.isResourceVisible(name, result, requestor)) {
                return result;
            }
            return null;
        }
        if (this.resourceLoader != null && (result = this.resourceLoader.findResource(name)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("findResource(...): resource found in libraries, name=" + name + ", URL=" + result + ", this=" + this + ", requestor=" + requestor));
            }
            if (this.isResourceVisible(name, result, requestor)) {
                return result;
            }
            return null;
        }
        if (seen == null) {
            seen = new HashSet<String>();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("findResource(...): resource not found, name=" + name + ", this=" + this + ", requestor=" + requestor));
        }
        seen.add(this.getPluginDescriptor().getId());
        for (PluginDescriptor element : this.publicImports) {
            if (!seen.contains(element.getId()) && (result = ((StandardPluginClassLoader)this.getPluginManager().getPluginClassLoader(element)).findResource(name, requestor, seen)) != null) break;
        }
        if (this == requestor && result == null) {
            for (PluginDescriptor element : this.privateImports) {
                if (!seen.contains(element.getId()) && (result = ((StandardPluginClassLoader)this.getPluginManager().getPluginClassLoader(element)).findResource(name, requestor, seen)) != null) break;
            }
        }
        if (result == null) {
            for (PluginDescriptor element : this.reverseLookups) {
                if (!seen.contains(element.getId()) && (result = ((StandardPluginClassLoader)this.getPluginManager().getPluginClassLoader(element)).findResource(name, requestor, seen)) != null) break;
            }
        }
        return result;
    }

    protected void findResources(List<URL> result, String name, StandardPluginClassLoader requestor, Set<String> seenPlugins) throws IOException {
        URL url;
        Set<String> seen = seenPlugins;
        if (seen != null && seen.contains(this.getPluginDescriptor().getId())) {
            return;
        }
        Enumeration<URL> enm = super.findResources(name);
        while (enm.hasMoreElements()) {
            url = enm.nextElement();
            if (!this.isResourceVisible(name, url, requestor)) continue;
            result.add(url);
        }
        if (this.resourceLoader != null) {
            enm = this.resourceLoader.findResources(name);
            while (enm.hasMoreElements()) {
                url = enm.nextElement();
                if (!this.isResourceVisible(name, url, requestor)) continue;
                result.add(url);
            }
        }
        if (seen == null) {
            seen = new HashSet<String>();
        }
        seen.add(this.getPluginDescriptor().getId());
        for (PluginDescriptor element : this.publicImports) {
            if (seen.contains(element.getId())) continue;
            ((StandardPluginClassLoader)this.getPluginManager().getPluginClassLoader(element)).findResources(result, name, requestor, seen);
        }
        if (this == requestor) {
            for (PluginDescriptor element : this.privateImports) {
                if (seen.contains(element.getId())) continue;
                ((StandardPluginClassLoader)this.getPluginManager().getPluginClassLoader(element)).findResources(result, name, requestor, seen);
            }
        }
        for (PluginDescriptor element : this.reverseLookups) {
            if (seen.contains(element.getId())) continue;
            ((StandardPluginClassLoader)this.getPluginManager().getPluginClassLoader(element)).findResources(result, name, requestor, seen);
        }
    }

    protected boolean isResourceVisible(String name, URL url, StandardPluginClassLoader requestor) {
        URL lib;
        if (this == requestor) {
            return true;
        }
        try {
            String file = url.getFile();
            lib = new URL(url.getProtocol(), url.getHost(), file.substring(0, file.length() - name.length()));
        }
        catch (MalformedURLException mue) {
            log.error((Object)"can't get resource library URL", (Throwable)mue);
            return false;
        }
        ResourceFilter filter = this.resourceFilters.get(lib.toExternalForm());
        if (filter == null) {
            log.warn((Object)("no resource filter found for library " + lib + ", name=" + name + ", URL=" + url + ", this=" + this + ", requestor=" + requestor));
            return false;
        }
        if (!filter.isResourceVisible(name)) {
            log.warn((Object)("resource not visible, name=" + name + ", URL=" + url + ", this=" + this + ", requestor=" + requestor));
            return false;
        }
        return true;
    }

    static {
        libCacheFolderInitialized = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PluginResourceLoader
    extends URLClassLoader {
        private static Log logger = LogFactory.getLog(PluginResourceLoader.class);

        static PluginResourceLoader get(PluginManager manager, PluginDescriptor descr) {
            final LinkedList<URL> urls = new LinkedList<URL>();
            for (Library lib : descr.getLibraries()) {
                if (lib.isCodeLibrary()) continue;
                urls.add(manager.getPathResolver().resolvePath(lib, lib.getPath()));
            }
            if (logger.isDebugEnabled()) {
                StringBuilder buf = new StringBuilder();
                buf.append("Resource URL's populated for plug-in " + descr + ":\r\n");
                for (URL url : urls) {
                    buf.append("\t");
                    buf.append(url);
                    buf.append("\r\n");
                }
                logger.trace((Object)buf.toString());
            }
            if (urls.isEmpty()) {
                return null;
            }
            return AccessController.doPrivileged(new PrivilegedAction<PluginResourceLoader>(){

                @Override
                public PluginResourceLoader run() {
                    return new PluginResourceLoader(urls.toArray(new URL[urls.size()]));
                }
            });
        }

        PluginResourceLoader(URL[] urls) {
            super(urls);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            throw new ClassNotFoundException(name);
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            throw new ClassNotFoundException(name);
        }
    }

    protected static final class ResourceFilter {
        private boolean isPublic;
        private final Set<String> entries = new HashSet<String>();

        protected ResourceFilter(Library lib) {
            for (String exportPrefix : lib.getExports()) {
                if ("*".equals(exportPrefix)) {
                    this.isPublic = true;
                    this.entries.clear();
                    break;
                }
                if (!lib.isCodeLibrary() && (exportPrefix = exportPrefix.replace('\\', '.').replace('/', '.')).startsWith(".")) {
                    exportPrefix = exportPrefix.substring(1);
                }
                this.entries.add(exportPrefix);
            }
        }

        protected boolean isClassVisible(String className) {
            if (this.isPublic) {
                return true;
            }
            if (this.entries.isEmpty()) {
                return false;
            }
            if (this.entries.contains(className)) {
                return true;
            }
            int p = className.lastIndexOf(46);
            if (p == -1) {
                return false;
            }
            return this.entries.contains(className.substring(0, p) + ".*");
        }

        protected boolean isResourceVisible(String resPath) {
            if (this.isPublic) {
                return true;
            }
            if (this.entries.isEmpty()) {
                return false;
            }
            String str = resPath.replace('\\', '.').replace('/', '.');
            if (str.startsWith(".")) {
                str = str.substring(1);
            }
            if (str.endsWith(".")) {
                str = str.substring(0, str.length() - 1);
            }
            return this.isClassVisible(str);
        }
    }
}

