/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.extract.apidb.v0_6;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.util.FileBasedLock;
import org.openstreetmap.osmosis.core.util.ResourceFileManager;
import org.openstreetmap.osmosis.extract.apidb.common.Configuration;
import org.openstreetmap.osmosis.extract.apidb.v0_6.DatabaseTimeLoader;
import org.openstreetmap.osmosis.extract.apidb.v0_6.IntervalExtractor;
import org.openstreetmap.osmosis.replication.common.TimestampTracker;

public class OsmosisExtractApiDb {
    private static final File LOCK_FILE = new File("osmosis-extract-apidb.lock");
    private static final File CONFIG_FILE = new File("osmosis-extract-apidb.conf");
    private static final File DATA_DIR = new File("data");
    private static final File TSTAMP_FILE = new File("timestamp.txt");
    private static final File TSTAMP_NEW_FILE = new File("timestampnew.txt");
    private static final File DATA_TSTAMP_FILE = new File("data/timestamp.txt");
    private static final File DATA_TSTAMP_NEW_FILE = new File("data/timestampnew.txt");
    private static final String CONFIG_RESOURCE = "osmosis-extract-apidb.conf";
    private static final String COMMAND_HELP = "help";
    private static final String COMMAND_INITIALIZE = "initialize";
    private static final String COMMAND_INFO = "info";
    private static final String COMMAND_EXTRACT = "extract";
    private static final String COMMAND_LINE_DATE_FORMAT = "yyyy-MM-dd_HH:mm:ss";
    private static final Locale COMMAND_LINE_DATE_LOCALE = Locale.US;
    private static final TimeZone COMMAND_LINE_DATE_TIMEZONE = TimeZone.getTimeZone("UTC");
    private final String[] programArgs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        FileBasedLock fileLock = new FileBasedLock(LOCK_FILE);
        boolean success = false;
        try {
            fileLock.lock();
            new OsmosisExtractApiDb(args).run();
            fileLock.unlock();
            success = true;
        }
        finally {
            fileLock.release();
        }
        if (success) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    public OsmosisExtractApiDb(String[] programArgs) {
        this.programArgs = programArgs;
    }

    public void run() {
        if (this.programArgs.length == 0) {
            this.helpCommand();
        } else {
            String command;
            int argIndex = 0;
            if (COMMAND_HELP.equals(command = this.programArgs[argIndex++])) {
                this.helpCommand();
            } else if (COMMAND_INITIALIZE.equals(command)) {
                this.initializeCommand(this.programArgs, argIndex);
            } else if (COMMAND_INFO.equals(command)) {
                this.infoCommand();
            } else if (COMMAND_EXTRACT.equals(command)) {
                this.extractCommand();
            } else {
                System.out.println("Command " + command + " is not recognised.");
            }
        }
    }

    private Configuration getConfiguration() {
        return new Configuration(CONFIG_FILE);
    }

    private TimestampTracker getTimestampTracker() {
        return new TimestampTracker(TSTAMP_FILE, TSTAMP_NEW_FILE);
    }

    private TimestampTracker getDataTimestampSetter() {
        return new TimestampTracker(DATA_TSTAMP_FILE, DATA_TSTAMP_NEW_FILE);
    }

    private Date getDateArgument(String[] args, int argIndex) {
        if (args.length <= argIndex) {
            throw new OsmosisRuntimeException("A date argument is required at argument " + (argIndex + 1) + ".");
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(COMMAND_LINE_DATE_FORMAT, COMMAND_LINE_DATE_LOCALE);
            dateFormat.setTimeZone(COMMAND_LINE_DATE_TIMEZONE);
            return dateFormat.parse(args[argIndex]);
        }
        catch (ParseException e) {
            throw new OsmosisRuntimeException("Argument " + (argIndex + 1) + " must be a date in format " + COMMAND_LINE_DATE_FORMAT + ".", (Throwable)e);
        }
    }

    private void helpCommand() {
        System.out.println("Osmosis Extract ApiDb Version 0.42-9-g7bd23cc-SNAPSHOT");
        System.out.println("Usage: osmosis-apidb-extract <command> <options>");
        System.out.println("Commands:");
        System.out.println("\tinitialize <yyyy-MM-dd_HH:mm:ss>");
        System.out.println("\tinfo");
        System.out.println("\textract");
    }

    private void initializeCommand(String[] args, int initialArgIndex) {
        int currentArgIndex = initialArgIndex;
        Date initialExtractDate = this.getDateArgument(args, currentArgIndex++);
        if (CONFIG_FILE.exists()) {
            throw new OsmosisRuntimeException("Config file " + CONFIG_FILE + " already exists.");
        }
        ResourceFileManager resourceFileManager = new ResourceFileManager();
        resourceFileManager.copyResourceToFile(this.getClass(), CONFIG_RESOURCE, CONFIG_FILE);
        if (!DATA_DIR.exists() && !DATA_DIR.mkdir()) {
            throw new OsmosisRuntimeException("Unable to create directory " + DATA_DIR);
        }
        if (TSTAMP_FILE.exists()) {
            throw new OsmosisRuntimeException("Extract timestamp file " + TSTAMP_FILE + " already exists.");
        }
        this.getTimestampTracker().setTime(initialExtractDate);
    }

    private void infoCommand() {
        Configuration configuration = this.getConfiguration();
        TimestampTracker timestampTracker = this.getTimestampTracker();
        System.out.println("Configuration");
        System.out.println("\thost: " + configuration.getHost());
        System.out.println("\tdatabase: " + configuration.getDatabase());
        System.out.println("\tuser: " + configuration.getUser());
        System.out.println("\tpassword: " + configuration.getPassword());
        System.out.println("\tdb: " + configuration.getDbType());
        System.out.println("\tintervalLength: " + configuration.getIntervalLength());
        System.out.println("\tlagLength: " + configuration.getLagLength());
        System.out.println("\tchangeSetBeginFormat: " + configuration.getChangeFileBeginFormat());
        System.out.println("\tchangeSetEndFormat: " + configuration.getChangeFileEndFormat());
        System.out.println();
        System.out.println("Data");
        System.out.println("\tCurrent Timestamp: " + timestampTracker.getTime());
    }

    private void extractCommand() {
        long maximumExtractTime;
        long nextExtractTime;
        Configuration configuration = this.getConfiguration();
        DatabaseTimeLoader timeLoader = new DatabaseTimeLoader(configuration.getDatabaseLoginCredentials());
        boolean fullHistory = configuration.getReadFullHistory();
        TimestampTracker timestampTracker = this.getTimestampTracker();
        TimestampTracker dataTimestampSetter = this.getDataTimestampSetter();
        long extractTime = timestampTracker.getTime().getTime();
        while ((nextExtractTime = extractTime + (long)configuration.getIntervalLength()) <= (maximumExtractTime = timeLoader.getDatabaseTime().getTime() - (long)configuration.getLagLength())) {
            Date intervalBegin = new Date(extractTime);
            Date intervalEnd = new Date(nextExtractTime);
            IntervalExtractor extractor = new IntervalExtractor(configuration, DATA_DIR, intervalBegin, intervalEnd, fullHistory);
            extractor.run();
            extractTime = nextExtractTime;
            timestampTracker.setTime(new Date(extractTime));
            dataTimestampSetter.setTime(new Date(extractTime));
        }
    }
}

