/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replicationhttp.v0_6;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSink;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSinkChangeSource;
import org.openstreetmap.osmosis.replication.common.ReplicationState;
import org.openstreetmap.osmosis.replicationhttp.v0_6.impl.SequenceNumberServerChannelPipelineFactory;
import org.openstreetmap.osmosis.replicationhttp.v0_6.impl.SequenceServer;

public class ReplicationSequenceServer
implements ChangeSinkChangeSource {
    private static final Logger LOG = Logger.getLogger(ReplicationSequenceServer.class.getName());
    private ChangeSink changeSink;
    private ReplicationState state;
    private long sequenceNumber;
    private SequenceServer server;
    private boolean serverStarted;

    public ReplicationSequenceServer(int port) {
        this.server = new SequenceServer(port, new SequenceNumberServerChannelPipelineFactory());
        this.serverStarted = false;
    }

    public void setChangeSink(ChangeSink changeSink) {
        this.changeSink = changeSink;
    }

    public int getPort() {
        return this.server.getPort();
    }

    public void initialize(Map<String, Object> metaData) {
        if (!metaData.containsKey("replication.state")) {
            throw new OsmosisRuntimeException("No replication state has been provided in metadata key replication.state.");
        }
        this.state = (ReplicationState)metaData.get("replication.state");
        this.changeSink.initialize(metaData);
        this.sequenceNumber = this.state.getSequenceNumber();
        if (this.sequenceNumber > 0L && !this.serverStarted) {
            this.server.start(this.sequenceNumber - 1L);
            this.serverStarted = true;
        }
    }

    public void process(ChangeContainer change) {
        this.changeSink.process(change);
    }

    public void complete() {
        this.changeSink.complete();
        if (!this.serverStarted) {
            this.server.start(this.sequenceNumber);
            this.serverStarted = true;
        } else {
            this.server.update(this.sequenceNumber);
        }
    }

    public void release() {
        this.changeSink.release();
        if (this.serverStarted) {
            try {
                this.server.stop();
            }
            catch (RuntimeException e) {
                LOG.log(Level.WARNING, "Replication sequence server stop failed.", e);
            }
            this.serverStarted = false;
        }
    }
}

