/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.v0_6.impl;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.core.lifecycle.Releasable;
import org.openstreetmap.osmosis.pgsnapshot.common.CompactPersistentNodeLocationStore;
import org.openstreetmap.osmosis.pgsnapshot.common.InMemoryNodeLocationStore;
import org.openstreetmap.osmosis.pgsnapshot.common.NodeLocation;
import org.openstreetmap.osmosis.pgsnapshot.common.NodeLocationStore;
import org.openstreetmap.osmosis.pgsnapshot.common.NodeLocationStoreType;
import org.openstreetmap.osmosis.pgsnapshot.common.PersistentNodeLocationStore;
import org.postgis.LineString;
import org.postgis.LinearRing;
import org.postgis.Point;
import org.postgis.Polygon;

public class WayGeometryBuilder
implements Releasable {
    protected NodeLocationStore locationStore;

    public WayGeometryBuilder(NodeLocationStoreType storeType) {
        if (NodeLocationStoreType.InMemory.equals((Object)storeType)) {
            this.locationStore = new InMemoryNodeLocationStore();
        } else if (NodeLocationStoreType.TempFile.equals((Object)storeType)) {
            this.locationStore = new PersistentNodeLocationStore();
        } else if (NodeLocationStoreType.CompactTempFile.equals((Object)storeType)) {
            this.locationStore = new CompactPersistentNodeLocationStore();
        } else {
            throw new OsmosisRuntimeException("The store type " + (Object)((Object)storeType) + " is not recognized.");
        }
    }

    public void addNodeLocation(Node node) {
        this.locationStore.addLocation(node.getId(), new NodeLocation(node.getLongitude(), node.getLatitude()));
    }

    public NodeLocation getNodeLocation(long nodeId) {
        return this.locationStore.getNodeLocation(nodeId);
    }

    private Polygon createWayBbox(double left, double right, double bottom, double top) {
        Point[] points = new Point[]{new Point(left, bottom), new Point(left, top), new Point(right, top), new Point(right, bottom), new Point(left, bottom)};
        LinearRing ring = new LinearRing(points);
        Polygon bbox = new Polygon(new LinearRing[]{ring});
        bbox.srid = 4326;
        return bbox;
    }

    public LineString createLinestring(List<Point> points) {
        LineString lineString = new LineString(points.toArray(new Point[0]));
        lineString.srid = 4326;
        return lineString;
    }

    public Point createPoint(long nodeId) {
        NodeLocation nodeLocation = this.locationStore.getNodeLocation(nodeId);
        Point point = new Point(nodeLocation.getLongitude(), nodeLocation.getLatitude());
        point.srid = 4326;
        return point;
    }

    public Polygon createWayBbox(Way way) {
        boolean nodesFound = false;
        double left = 0.0;
        double right = 0.0;
        double bottom = 0.0;
        double top = 0.0;
        for (WayNode wayNode : way.getWayNodes()) {
            NodeLocation nodeLocation = this.locationStore.getNodeLocation(wayNode.getNodeId());
            double longitude = nodeLocation.getLongitude();
            double latitude = nodeLocation.getLatitude();
            if (!nodeLocation.isValid()) continue;
            if (nodesFound) {
                if (longitude < left) {
                    left = longitude;
                }
                if (longitude > right) {
                    right = longitude;
                }
                if (latitude < bottom) {
                    bottom = latitude;
                }
                if (!(latitude > top)) continue;
                top = latitude;
                continue;
            }
            left = longitude;
            right = longitude;
            bottom = latitude;
            top = latitude;
            nodesFound = true;
        }
        return this.createWayBbox(left, right, bottom, top);
    }

    public LineString createWayLinestring(Way way) {
        ArrayList<Point> linePoints = new ArrayList<Point>();
        for (WayNode wayNode : way.getWayNodes()) {
            NodeLocation nodeLocation = this.locationStore.getNodeLocation(wayNode.getNodeId());
            if (nodeLocation.isValid()) {
                linePoints.add(new Point(nodeLocation.getLongitude(), nodeLocation.getLatitude()));
                continue;
            }
            return null;
        }
        return this.createLinestring(linePoints);
    }

    public void release() {
        this.locationStore.release();
    }
}

