/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.v0_6.impl;

import java.util.Map;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.pgsnapshot.common.PointBuilder;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.ActionDataType;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.EntityMapper;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.NodeRowMapper;
import org.postgis.Geometry;
import org.postgis.PGgeometry;
import org.springframework.jdbc.core.RowMapper;

public class NodeMapper
extends EntityMapper<Node> {
    private PointBuilder pointBuilder = new PointBuilder();

    @Override
    public String getEntityName() {
        return "node";
    }

    @Override
    public ActionDataType getEntityType() {
        return ActionDataType.NODE;
    }

    @Override
    public Class<Node> getEntityClass() {
        return Node.class;
    }

    @Override
    protected String[] getTypeSpecificFieldNames() {
        return new String[]{"geom"};
    }

    @Override
    public void populateEntityParameters(Map<String, Object> args, Node entity) {
        this.populateCommonEntityParameters(args, (Entity)entity);
        args.put("geom", new PGgeometry((Geometry)this.pointBuilder.createPoint(entity.getLatitude(), entity.getLongitude())));
    }

    @Override
    public RowMapper<Node> getRowMapper() {
        return new NodeRowMapper();
    }
}

