/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.v0_6.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.domain.v0_6.CommonEntityData;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.OsmUser;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.hstore.PGHStore;
import org.springframework.jdbc.core.RowMapper;

public abstract class EntityRowMapper<T extends Entity>
implements RowMapper<T> {
    private OsmUser buildUser(ResultSet resultSet) {
        try {
            int userId = resultSet.getInt("user_id");
            OsmUser user = userId == OsmUser.NONE.getId() ? OsmUser.NONE : new OsmUser(userId, resultSet.getString("user_name"));
            return user;
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to build a user from the current recordset row.", (Throwable)e);
        }
    }

    protected CommonEntityData mapCommonEntityData(ResultSet rs) throws SQLException {
        CommonEntityData entityData = new CommonEntityData(rs.getLong("id"), rs.getInt("version"), new Date(rs.getTimestamp("tstamp").getTime()), this.buildUser(rs), rs.getLong("changeset_id"));
        PGHStore dbTags = (PGHStore)rs.getObject("tags");
        if (dbTags != null) {
            Collection tags = entityData.getTags();
            for (Map.Entry tagEntry : dbTags.entrySet()) {
                tags.add(new Tag((String)tagEntry.getKey(), (String)tagEntry.getValue()));
            }
        }
        return entityData;
    }
}

