/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.v0_6.impl;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.OsmUser;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.task.common.ChangeAction;
import org.openstreetmap.osmosis.pgsnapshot.common.DatabaseContext;
import org.openstreetmap.osmosis.pgsnapshot.common.NoSuchRecordException;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.ActionDao;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.NodeDao;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.RelationDao;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.UserDao;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.WayDao;
import org.springframework.jdbc.core.CallableStatementCreator;

public class ChangeWriter {
    private DatabaseContext dbCtx;
    private ActionDao actionDao;
    private UserDao userDao;
    private NodeDao nodeDao;
    private WayDao wayDao;
    private RelationDao relationDao;
    private Set<Integer> userSet;

    public ChangeWriter(DatabaseContext dbCtx) {
        this.dbCtx = dbCtx;
        this.actionDao = new ActionDao(dbCtx);
        this.userDao = new UserDao(dbCtx, this.actionDao);
        this.nodeDao = new NodeDao(dbCtx, this.actionDao);
        this.wayDao = new WayDao(dbCtx, this.actionDao);
        this.relationDao = new RelationDao(dbCtx, this.actionDao);
        this.userSet = new HashSet<Integer>();
    }

    private void writeUser(OsmUser user) {
        if (!OsmUser.NONE.equals((Object)user) && !this.userSet.contains(user.getId())) {
            int userId = user.getId();
            try {
                OsmUser existingUser = this.userDao.getUser(userId);
                if (!user.equals((Object)existingUser)) {
                    this.userDao.updateUser(user);
                }
            }
            catch (NoSuchRecordException e) {
                this.userDao.addUser(user);
            }
            this.userSet.add(user.getId());
        }
    }

    private void processEntityPrerequisites(Entity entity) {
        if (entity.getTimestamp() == null) {
            throw new OsmosisRuntimeException("Entity(" + entity.getType() + ") " + entity.getId() + " does not have a timestamp set.");
        }
        this.writeUser(entity.getUser());
    }

    public void write(Node node, ChangeAction action) {
        this.processEntityPrerequisites((Entity)node);
        if (ChangeAction.Create.equals((Object)action) || ChangeAction.Modify.equals((Object)action)) {
            if (this.nodeDao.exists(node.getId())) {
                this.nodeDao.modifyEntity(node);
            } else {
                this.nodeDao.addEntity(node);
            }
        } else {
            this.nodeDao.removeEntity(node.getId());
        }
    }

    public void write(Way way, ChangeAction action, boolean keepInvalidWays) {
        this.processEntityPrerequisites((Entity)way);
        if (ChangeAction.Create.equals((Object)action) || ChangeAction.Modify.equals((Object)action)) {
            if (this.wayDao.exists(way.getId())) {
                if (way.getWayNodes().size() >= 2 || keepInvalidWays) {
                    this.wayDao.modifyEntity(way);
                } else {
                    this.wayDao.removeEntity(way.getId());
                }
            } else if (way.getWayNodes().size() >= 2 || keepInvalidWays) {
                this.wayDao.addEntity(way);
            }
        } else {
            this.wayDao.removeEntity(way.getId());
        }
    }

    public void write(Relation relation, ChangeAction action) {
        this.processEntityPrerequisites((Entity)relation);
        if (ChangeAction.Create.equals((Object)action) || ChangeAction.Modify.equals((Object)action)) {
            if (this.relationDao.exists(relation.getId())) {
                this.relationDao.modifyEntity(relation);
            } else {
                this.relationDao.addEntity(relation);
            }
        } else {
            this.relationDao.removeEntity(relation.getId());
        }
    }

    public void complete() {
        this.dbCtx.getJdbcTemplate().call(new CallableStatementCreator(){

            public CallableStatement createCallableStatement(Connection con) throws SQLException {
                return con.prepareCall("{call osmosisUpdate()}");
            }
        }, new ArrayList());
        this.actionDao.truncate();
    }

    public void release() {
    }
}

