/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.common;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.util.FixedPrecisionCoordinateConvertor;
import org.openstreetmap.osmosis.pgsnapshot.common.NodeLocation;
import org.openstreetmap.osmosis.pgsnapshot.common.NodeLocationStore;

public class InMemoryNodeLocationStore
implements NodeLocationStore {
    private static final Logger LOG = Logger.getLogger(InMemoryNodeLocationStore.class.getName());
    private static final int NODE_DATA_SIZE = 9;
    private static final int BUFFER_ELEMENT_COUNT = 131072;
    private static final int BUFFER_SIZE = 0x120000;
    private List<byte[]> buffers = new ArrayList<byte[]>();
    private NodeLocation invalidNodeLocation = new NodeLocation();

    private void logMemoryConsumption(Level level) {
        if (LOG.isLoggable(level)) {
            Runtime runtime = Runtime.getRuntime();
            DecimalFormat percentageFormat = new DecimalFormat("#0.##");
            double percentageUsed = (double)runtime.totalMemory() / (double)runtime.maxMemory() * 100.0;
            long totalUsed = (long)this.buffers.size() * 0x120000L / 0x100000L;
            long maxMemory = runtime.maxMemory() / 0x100000L;
            LOG.log(level, "The store contains " + this.buffers.size() + " buffers of " + 1152 + "KB, total " + totalUsed + "MB.");
            LOG.log(level, "The JVM is using " + percentageFormat.format(percentageUsed) + "% of the maximum " + maxMemory + "MB of memory.");
        }
    }

    private void writeIntToBuffer(int value, byte[] buffer, int initialOffset) {
        int offset = initialOffset;
        buffer[offset++] = (byte)(value >>> 24);
        buffer[offset++] = (byte)(value >>> 16);
        buffer[offset++] = (byte)(value >>> 8);
        buffer[offset++] = (byte)value;
    }

    private int readIntFromBuffer(byte[] buffer, int initialOffset) {
        int offset = initialOffset;
        return (buffer[offset++] << 24) + ((buffer[offset++] & 0xFF) << 16) + ((buffer[offset++] & 0xFF) << 8) + (buffer[offset++] & 0xFF);
    }

    @Override
    public void addLocation(long nodeId, NodeLocation nodeLocation) {
        byte[] buffer;
        int bufferIndex = (int)(nodeId / 131072L);
        while (bufferIndex >= this.buffers.size()) {
            buffer = new byte[0x120000];
            this.buffers.add(buffer);
            this.logMemoryConsumption(Level.FINER);
        }
        buffer = this.buffers.get(bufferIndex);
        int bufferOffset = (int)((nodeId - (long)(bufferIndex * 131072)) * 9L);
        buffer[bufferOffset++] = 1;
        this.writeIntToBuffer(FixedPrecisionCoordinateConvertor.convertToFixed((double)nodeLocation.getLongitude()), buffer, bufferOffset);
        this.writeIntToBuffer(FixedPrecisionCoordinateConvertor.convertToFixed((double)nodeLocation.getLatitude()), buffer, bufferOffset += 4);
        bufferOffset += 4;
    }

    @Override
    public NodeLocation getNodeLocation(long nodeId) {
        NodeLocation nodeLocation = this.invalidNodeLocation;
        int bufferIndex = (int)(nodeId / 131072L);
        if (bufferIndex < this.buffers.size()) {
            byte validFlag;
            byte[] buffer = this.buffers.get(bufferIndex);
            int bufferOffset = (int)((nodeId - (long)(bufferIndex * 131072)) * 9L);
            if ((validFlag = buffer[bufferOffset++]) != 0) {
                int longitude = this.readIntFromBuffer(buffer, bufferOffset);
                int latitude = this.readIntFromBuffer(buffer, bufferOffset += 4);
                bufferOffset += 4;
                nodeLocation = new NodeLocation(FixedPrecisionCoordinateConvertor.convertToDouble((int)longitude), FixedPrecisionCoordinateConvertor.convertToDouble((int)latitude));
            }
        }
        return nodeLocation;
    }

    public void release() {
        this.logMemoryConsumption(Level.FINE);
    }
}

