/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.common;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;
import org.openstreetmap.osmosis.pgsnapshot.common.DataSourceManager;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class DatabaseContext {
    private static final Logger LOG = Logger.getLogger(DatabaseContext.class.getName());
    private DataSourceManager dataSourceManager;
    private DataSource dataSource;
    private PlatformTransactionManager txnManager;
    private TransactionTemplate txnTemplate;
    private TransactionStatus transaction;
    private JdbcTemplate jdbcTemplate;

    public DatabaseContext(DatabaseLoginCredentials loginCredentials) {
        this.dataSourceManager = new DataSourceManager(loginCredentials);
        this.dataSource = this.dataSourceManager.getDataSource();
        this.txnManager = new DataSourceTransactionManager(this.dataSource);
        this.txnTemplate = new TransactionTemplate(this.txnManager);
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        this.setStatementFetchSizeForStreaming();
    }

    public void beginTransaction() {
        if (this.transaction != null) {
            throw new OsmosisRuntimeException("A transaction is already active.");
        }
        this.transaction = this.txnManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTransaction() {
        if (this.transaction == null) {
            throw new OsmosisRuntimeException("No transaction is currently active.");
        }
        try {
            this.txnManager.commit(this.transaction);
        }
        finally {
            this.transaction = null;
        }
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public <T> Object executeWithinTransaction(TransactionCallback<T> txnCallback) {
        return this.txnTemplate.execute(txnCallback);
    }

    private void setStatementFetchSizeForStreaming() {
        this.jdbcTemplate.setFetchSize(10000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this.transaction != null) {
            try {
                this.txnManager.rollback(this.transaction);
            }
            finally {
                this.transaction = null;
            }
        }
        this.dataSourceManager.release();
    }

    public boolean doesColumnExist(String tableName, String columnName) {
        ResultSet resultSet = null;
        try {
            LOG.finest("Checking if column {" + columnName + "} in table {" + tableName + "} exists.");
            Connection connection = DataSourceUtils.getConnection((DataSource)this.dataSource);
            resultSet = connection.getMetaData().getColumns(null, null, tableName, columnName);
            boolean result = resultSet.next();
            resultSet.close();
            resultSet = null;
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.dataSource);
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to check for the existence of column " + tableName + "." + columnName + ".", (Throwable)e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    LOG.log(Level.WARNING, "Unable to close column existence result set.", e);
                }
            }
        }
    }

    public boolean doesTableExist(String tableName) {
        ResultSet resultSet = null;
        try {
            LOG.finest("Checking if table {" + tableName + "} exists.");
            Connection connection = DataSourceUtils.getConnection((DataSource)this.dataSource);
            resultSet = connection.getMetaData().getTables(null, null, tableName, new String[]{"TABLE"});
            boolean result = resultSet.next();
            resultSet.close();
            resultSet = null;
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.dataSource);
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to check for the existence of table " + tableName + ".", (Throwable)e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    LOG.log(Level.WARNING, "Unable to close table existence result set.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCopyFile(File copyFile, String tableName, String ... columns) {
        InputStream inStream = null;
        try {
            StringBuilder copyStatement = new StringBuilder();
            copyStatement.append("COPY ");
            copyStatement.append(tableName);
            if (columns.length > 0) {
                copyStatement.append('(');
                for (int i = 0; i < columns.length; ++i) {
                    if (i > 0) {
                        copyStatement.append(',');
                    }
                    copyStatement.append(columns[i]);
                }
                copyStatement.append(')');
            }
            copyStatement.append(" FROM STDIN");
            inStream = new FileInputStream(copyFile);
            BufferedInputStream bufferedInStream = new BufferedInputStream(inStream, 65536);
            Connection conn = DataSourceUtils.getConnection((DataSource)this.dataSource);
            try {
                CopyManager copyManager = new CopyManager(conn.unwrap(BaseConnection.class));
                copyManager.copyIn(copyStatement.toString(), (InputStream)bufferedInStream);
            }
            finally {
                DataSourceUtils.releaseConnection((Connection)conn, (DataSource)this.dataSource);
            }
            inStream.close();
            inStream = null;
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to process COPY file " + copyFile + ".", (Throwable)e);
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to process COPY file " + copyFile + ".", (Throwable)e);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "Unable to close COPY file.", e);
                }
                inStream = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }
}

