/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.extract.apidb.v0_6;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.apidb.common.DatabaseContext;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;

public class DatabaseTimeLoader {
    private static final Logger LOG = Logger.getLogger(DatabaseTimeLoader.class.getName());
    private DatabaseLoginCredentials loginCredentials;

    public DatabaseTimeLoader(DatabaseLoginCredentials loginCredentials) {
        this.loginCredentials = loginCredentials;
    }

    private Date readTimeField(ResultSet timeSet) {
        ResultSet rs = timeSet;
        try {
            timeSet.next();
            Timestamp dbTime = timeSet.getTimestamp("SystemTime");
            Date result = new Date(((Date)dbTime).getTime());
            rs.close();
            rs = null;
            Date date = result;
            return date;
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to read the time from the database server.", (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    LOG.log(Level.WARNING, "Unable to close result set.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDatabaseTime() {
        DatabaseContext dbCtx = new DatabaseContext(this.loginCredentials);
        try {
            Date result;
            ResultSet rs = dbCtx.executeQuery("SELECT now() AS SystemTime");
            Date date = result = this.readTimeField(rs);
            return date;
        }
        finally {
            dbCtx.release();
        }
    }
}

