/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replicationhttp.v0_6.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.util.CharsetUtil;
import org.openstreetmap.osmosis.replicationhttp.v0_6.impl.SequenceClientControl;
import org.openstreetmap.osmosis.replicationhttp.v0_6.impl.SequenceClientHandler;
import org.openstreetmap.osmosis.replicationhttp.v0_6.impl.SequenceNumberClientListener;

public class SequenceNumberClientHandler
extends SequenceClientHandler {
    private static final Logger LOG = Logger.getLogger(SequenceNumberClientHandler.class.getName());
    private SequenceNumberClientListener sequenceNumberListener;

    public SequenceNumberClientHandler(SequenceClientControl control, SequenceNumberClientListener sequenceNumberListener, String serverHost) {
        super(control, serverHost);
        this.sequenceNumberListener = sequenceNumberListener;
    }

    @Override
    protected String getRequestUri() {
        return "/sequenceNumber/current/tail";
    }

    @Override
    protected void processMessageData(ChannelBuffer buffer) {
        String sequenceNumberString = buffer.toString(CharsetUtil.UTF_8);
        long sequenceNumber = Long.parseLong(sequenceNumberString);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Received sequence number " + sequenceNumber);
        }
        this.sequenceNumberListener.notifySequenceNumber(sequenceNumber);
    }
}

