/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.dataset.v0_6.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.openstreetmap.osmosis.core.lifecycle.Completable;
import org.openstreetmap.osmosis.core.lifecycle.Releasable;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableContainer;
import org.openstreetmap.osmosis.core.store.IndexElement;
import org.openstreetmap.osmosis.core.store.IndexStore;
import org.openstreetmap.osmosis.core.store.IndexStoreReader;
import org.openstreetmap.osmosis.core.store.IntegerLongIndexElement;
import org.openstreetmap.osmosis.core.store.UnsignedIntegerComparator;
import org.openstreetmap.osmosis.dataset.v0_6.impl.DatasetStoreFileManager;
import org.openstreetmap.osmosis.dataset.v0_6.impl.WayTileAreaIndexReader;

public class WayTileAreaIndex
implements Completable {
    private static final int[] MASKS = new int[]{-1, -16, -256, -65536, -16777216, 0};
    private List<IndexStore<Integer, IntegerLongIndexElement>> indexes = new ArrayList<IndexStore<Integer, IntegerLongIndexElement>>(MASKS.length);

    public WayTileAreaIndex(DatasetStoreFileManager fileManager) {
        for (int i = 0; i < MASKS.length; ++i) {
            this.indexes.add((IndexStore<Integer, IntegerLongIndexElement>)new IndexStore(IntegerLongIndexElement.class, (Comparator)new UnsignedIntegerComparator(), fileManager.getWayTileIndexFile(i)));
        }
    }

    public void write(long wayId, int minimumTile, int maximumTile) {
        for (int i = 0; i < MASKS.length; ++i) {
            int mask = MASKS[i];
            int maskedMinimum = mask & minimumTile;
            int maskedMaximum = mask & maximumTile;
            if (maskedMinimum != maskedMaximum) continue;
            this.indexes.get(i).write((IndexElement)new IntegerLongIndexElement(maskedMinimum, wayId));
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WayTileAreaIndexReader createReader() {
        ReleasableContainer releasableContainer = new ReleasableContainer();
        try {
            ArrayList<IndexStoreReader<Integer, IntegerLongIndexElement>> indexReaders = new ArrayList<IndexStoreReader<Integer, IntegerLongIndexElement>>(MASKS.length);
            for (IndexStore<Integer, IntegerLongIndexElement> index : this.indexes) {
                indexReaders.add((IndexStoreReader<Integer, IntegerLongIndexElement>)releasableContainer.add((Releasable)index.createReader()));
            }
            releasableContainer.clear();
            WayTileAreaIndexReader wayTileAreaIndexReader = new WayTileAreaIndexReader(MASKS, indexReaders);
            return wayTileAreaIndexReader;
        }
        finally {
            releasableContainer.release();
        }
    }

    public void complete() {
        for (IndexStore<Integer, IntegerLongIndexElement> index : this.indexes) {
            index.complete();
        }
    }

    public void release() {
        for (IndexStore<Integer, IntegerLongIndexElement> index : this.indexes) {
            index.release();
        }
    }
}

