/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pbf2.v0_6;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.task.v0_6.RunnableSource;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.pbf2.v0_6.impl.PbfDecoder;
import org.openstreetmap.osmosis.pbf2.v0_6.impl.PbfStreamSplitter;

public class PbfReader
implements RunnableSource {
    private File file;
    private Sink sink;
    private int workers;

    public PbfReader(File file, int workers) {
        this.file = file;
        this.workers = workers;
    }

    public void setSink(Sink sink) {
        this.sink = sink;
    }

    public void run() {
        PbfStreamSplitter streamSplitter = null;
        ExecutorService executorService = Executors.newFixedThreadPool(this.workers);
        try {
            this.sink.initialize(Collections.emptyMap());
            InputStream inputStream = this.file.getName().equals("-") ? System.in : new FileInputStream(this.file);
            streamSplitter = new PbfStreamSplitter(new DataInputStream(inputStream));
            PbfDecoder pbfDecoder = new PbfDecoder(streamSplitter, executorService, this.workers + 1, this.sink);
            pbfDecoder.run();
            this.sink.complete();
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to read PBF file " + this.file + ".", (Throwable)e);
        }
        finally {
            this.sink.release();
            executorService.shutdownNow();
            if (streamSplitter != null) {
                streamSplitter.release();
            }
        }
    }
}

