/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.tagfilter.v0_6;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.core.task.v0_6.SinkSource;

public class TagRemover
implements SinkSource {
    private Sink sink;
    private HashSet<String> keysToDrop = new HashSet();
    private String[] keyPrefixesToDrop;

    public TagRemover(String keyList, String keyPrefixList) {
        String[] keys = keyList.split(",");
        for (int i = 0; i < keys.length; ++i) {
            this.keysToDrop.add(keys[i]);
        }
        this.keyPrefixesToDrop = keyPrefixList.split(",");
        if (this.keyPrefixesToDrop[0] == "") {
            this.keyPrefixesToDrop = new String[0];
        }
    }

    public void setSink(Sink sink) {
        this.sink = sink;
    }

    public void initialize(Map<String, Object> metaData) {
        this.sink.initialize(metaData);
    }

    public void process(EntityContainer entityContainer) {
        EntityContainer writeableContainer = entityContainer.getWriteableInstance();
        Entity entity = writeableContainer.getEntity();
        Iterator i = entity.getTags().iterator();
        block0: while (i.hasNext()) {
            Tag tag = (Tag)i.next();
            if (this.keysToDrop.contains(tag.getKey())) {
                i.remove();
                continue;
            }
            for (String prefix : this.keyPrefixesToDrop) {
                if (!tag.getKey().startsWith(prefix)) continue;
                i.remove();
                continue block0;
            }
        }
        this.sink.process(writeableContainer);
    }

    public void complete() {
        this.sink.complete();
    }

    public void release() {
        this.sink.release();
    }
}

