/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.tagfilter.v0_6;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.osmosis.core.pipeline.common.TaskConfiguration;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManager;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManagerFactory;
import org.openstreetmap.osmosis.core.pipeline.v0_6.SinkSourceManager;
import org.openstreetmap.osmosis.core.task.v0_6.SinkSource;
import org.openstreetmap.osmosis.tagfilter.v0_6.TagFilter;

public class TagFilterFactory
extends TaskManagerFactory {
    private String unEscape(String s) {
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        for (char c : s.toCharArray()) {
            if (escaped) {
                switch (c) {
                    case '%': {
                        sb.append('%');
                        break;
                    }
                    case 'a': {
                        sb.append('*');
                        break;
                    }
                    case 'c': {
                        sb.append(',');
                        break;
                    }
                    case 'e': {
                        sb.append('=');
                        break;
                    }
                    case 's': {
                        sb.append(' ');
                        break;
                    }
                }
                escaped = false;
                continue;
            }
            if (c == '%') {
                escaped = true;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected TaskManager createTaskManagerImpl(TaskConfiguration taskConfig) {
        HashSet<String> keys = new HashSet<String>();
        HashMap<String, Set<String>> keyValues = new HashMap<String, Set<String>>();
        for (String key : taskConfig.getConfigArgs().keySet()) {
            String value = this.getStringArgument(taskConfig, key);
            if (value.equals("*")) {
                keys.add(this.unEscape(key));
                continue;
            }
            HashSet<String> values = new HashSet<String>();
            for (String v : value.split(",")) {
                values.add(this.unEscape(v));
            }
            keyValues.put(this.unEscape(key), values);
        }
        return new SinkSourceManager(taskConfig.getId(), (SinkSource)new TagFilter(this.getDefaultStringArgument(taskConfig, ""), keys, keyValues), taskConfig.getPipeArgs());
    }
}

