/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.v0_6.impl;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.osmosis.core.database.DbOrderedFeature;
import org.openstreetmap.osmosis.core.database.FeaturePopulator;
import org.openstreetmap.osmosis.core.database.RelationMemberCollectionLoader;
import org.openstreetmap.osmosis.core.database.RowMapperListener;
import org.openstreetmap.osmosis.core.database.SortingStoreRowMapperListener;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.core.lifecycle.Releasable;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.sort.common.FileBasedSort;
import org.openstreetmap.osmosis.core.store.ObjectSerializationFactory;
import org.openstreetmap.osmosis.core.store.SingleClassObjectSerializationFactory;
import org.openstreetmap.osmosis.core.store.StoreReleasingIterator;
import org.openstreetmap.osmosis.core.store.Storeable;
import org.openstreetmap.osmosis.core.store.UpcastIterator;
import org.openstreetmap.osmosis.pgsnapshot.common.DatabaseContext;
import org.openstreetmap.osmosis.pgsnapshot.common.RowMapperRowCallbackListener;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.ActionDao;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.DbOrderedFeatureComparator;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.EntityDao;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.EntityFeatureDao;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.FeaturePopulatorImpl;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.RelationMapper;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.RelationMemberMapper;
import org.springframework.jdbc.core.JdbcTemplate;

public class RelationDao
extends EntityDao<Relation> {
    private JdbcTemplate jdbcTemplate;
    private EntityFeatureDao<RelationMember, DbOrderedFeature<RelationMember>> relationMemberDao;
    private RelationMemberMapper relationMemberMapper;

    public RelationDao(DatabaseContext dbCtx, ActionDao actionDao) {
        super(dbCtx.getJdbcTemplate(), new RelationMapper(), actionDao);
        this.jdbcTemplate = dbCtx.getJdbcTemplate();
        this.relationMemberMapper = new RelationMemberMapper();
        this.relationMemberDao = new EntityFeatureDao(dbCtx.getJdbcTemplate(), this.relationMemberMapper);
    }

    private void loadFeatures(long entityId, Relation entity) {
        entity.getMembers().addAll(this.relationMemberDao.getAllRaw(entityId));
    }

    @Override
    public Relation getEntity(long entityId) {
        Relation entity = (Relation)super.getEntity(entityId);
        this.loadFeatures(entityId, entity);
        return entity;
    }

    private void addMembers(long entityId, List<RelationMember> memberList) {
        ArrayList<DbOrderedFeature> dbList = new ArrayList<DbOrderedFeature>(memberList.size());
        for (int i = 0; i < memberList.size(); ++i) {
            dbList.add(new DbOrderedFeature(entityId, (Storeable)memberList.get(i), i));
        }
        this.relationMemberDao.addAll(dbList);
    }

    @Override
    public void addEntity(Relation entity) {
        super.addEntity(entity);
        this.addMembers(entity.getId(), entity.getMembers());
    }

    @Override
    public void modifyEntity(Relation entity) {
        super.modifyEntity(entity);
        long relationId = entity.getId();
        this.relationMemberDao.removeList(relationId);
        this.addMembers(entity.getId(), entity.getMembers());
    }

    @Override
    public void removeEntity(long entityId) {
        this.relationMemberDao.removeList(entityId);
        super.removeEntity(entityId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReleasableIterator<DbOrderedFeature<RelationMember>> getRelationMembers(String tablePrefix) {
        FileBasedSort sortingStore = new FileBasedSort((ObjectSerializationFactory)new SingleClassObjectSerializationFactory(DbOrderedFeature.class), new DbOrderedFeatureComparator(), true);
        try {
            String sql = this.relationMemberMapper.getSqlSelect(tablePrefix, false, false);
            SortingStoreRowMapperListener storeListener = new SortingStoreRowMapperListener(sortingStore);
            RowMapperRowCallbackListener<DbOrderedFeature<RelationMember>> rowCallbackListener = new RowMapperRowCallbackListener<DbOrderedFeature<RelationMember>>(this.relationMemberMapper.getRowMapper(), (RowMapperListener<DbOrderedFeature<RelationMember>>)storeListener);
            this.jdbcTemplate.query(sql, rowCallbackListener);
            StoreReleasingIterator resultIterator = new StoreReleasingIterator(sortingStore.iterate(), (Releasable)sortingStore);
            sortingStore = null;
            StoreReleasingIterator storeReleasingIterator = resultIterator;
            return storeReleasingIterator;
        }
        finally {
            if (sortingStore != null) {
                sortingStore.release();
            }
        }
    }

    @Override
    protected List<FeaturePopulator<Relation>> getFeaturePopulators(String tablePrefix) {
        ArrayList<FeaturePopulator<Relation>> featurePopulators = new ArrayList<FeaturePopulator<Relation>>();
        UpcastIterator relationMemberIterator = new UpcastIterator(this.getRelationMembers(tablePrefix));
        featurePopulators.add(new FeaturePopulatorImpl(relationMemberIterator, new RelationMemberCollectionLoader()));
        return featurePopulators;
    }
}

