/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.v0_6.impl;

import java.util.logging.Logger;
import org.openstreetmap.osmosis.pgsnapshot.common.DatabaseContext;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.DatabaseCapabilityChecker;
import org.springframework.jdbc.core.JdbcTemplate;

public class IndexManager {
    private static final Logger LOG = Logger.getLogger(IndexManager.class.getName());
    private static final String[] PRE_LOAD_SQL = new String[]{"ALTER TABLE users DROP CONSTRAINT pk_users", "ALTER TABLE nodes DROP CONSTRAINT pk_nodes", "ALTER TABLE ways DROP CONSTRAINT pk_ways", "ALTER TABLE way_nodes DROP CONSTRAINT pk_way_nodes", "ALTER TABLE relations DROP CONSTRAINT pk_relations", "ALTER TABLE relation_members DROP CONSTRAINT pk_relation_members", "DROP INDEX idx_nodes_geom", "DROP INDEX idx_way_nodes_node_id", "DROP INDEX idx_relation_members_member_id_and_type"};
    private static final String[] PRE_LOAD_SQL_WAY_BBOX = new String[]{"DROP INDEX idx_ways_bbox"};
    private static final String[] PRE_LOAD_SQL_WAY_LINESTRING = new String[]{"DROP INDEX idx_ways_linestring"};
    private static final String[] POST_LOAD_SQL = new String[]{"ALTER TABLE ONLY users ADD CONSTRAINT pk_users PRIMARY KEY (id)", "ALTER TABLE ONLY nodes ADD CONSTRAINT pk_nodes PRIMARY KEY (id)", "ALTER TABLE ONLY ways ADD CONSTRAINT pk_ways PRIMARY KEY (id)", "ALTER TABLE ONLY way_nodes ADD CONSTRAINT pk_way_nodes PRIMARY KEY (way_id, sequence_id)", "ALTER TABLE ONLY relations ADD CONSTRAINT pk_relations PRIMARY KEY (id)", "ALTER TABLE ONLY relation_members ADD CONSTRAINT pk_relation_members PRIMARY KEY (relation_id, sequence_id)", "CREATE INDEX idx_nodes_geom ON nodes USING gist (geom)", "CREATE INDEX idx_way_nodes_node_id ON way_nodes USING btree (node_id)", "CREATE INDEX idx_relation_members_member_id_and_type ON relation_members USING btree (member_id, member_type)"};
    private static final String[] POST_LOAD_SQL_WAY_BBOX = new String[]{"CREATE INDEX idx_ways_bbox ON ways USING gist (bbox)"};
    private static final String[] POST_LOAD_SQL_WAY_LINESTRING = new String[]{"CREATE INDEX idx_ways_linestring ON ways USING gist (linestring)"};
    private static final String POST_LOAD_SQL_POPULATE_WAY_BBOX = "UPDATE ways SET bbox = (SELECT ST_Envelope(ST_Collect(geom)) FROM nodes JOIN way_nodes ON way_nodes.node_id = nodes.id WHERE way_nodes.way_id = ways.id)";
    private static final String POST_LOAD_SQL_POPULATE_WAY_LINESTRING = "UPDATE ways w SET linestring = (SELECT ST_MakeLine(c.geom) AS way_line FROM (SELECT n.geom AS geom FROM nodes n INNER JOIN way_nodes wn ON n.id = wn.node_id WHERE (wn.way_id = w.id) ORDER BY wn.sequence_id) c)";
    private JdbcTemplate jdbcTemplate;
    private DatabaseCapabilityChecker capabilityChecker;
    private boolean populateBbox;
    private boolean populateLinestring;

    public IndexManager(DatabaseContext dbCtx, boolean populateBbox, boolean populateLinestring) {
        this.populateBbox = populateBbox;
        this.populateLinestring = populateLinestring;
        this.jdbcTemplate = dbCtx.getJdbcTemplate();
        this.capabilityChecker = new DatabaseCapabilityChecker(dbCtx);
    }

    public void prepareForLoad() {
        int i;
        LOG.fine("Running pre-load SQL statements.");
        for (i = 0; i < PRE_LOAD_SQL.length; ++i) {
            LOG.finer("SQL: " + PRE_LOAD_SQL[i]);
            this.jdbcTemplate.update(PRE_LOAD_SQL[i]);
        }
        if (this.capabilityChecker.isWayBboxSupported()) {
            LOG.fine("Running pre-load bbox SQL statements.");
            for (i = 0; i < PRE_LOAD_SQL_WAY_BBOX.length; ++i) {
                LOG.finer("SQL: " + PRE_LOAD_SQL_WAY_BBOX[i]);
                this.jdbcTemplate.update(PRE_LOAD_SQL_WAY_BBOX[i]);
            }
        }
        if (this.capabilityChecker.isWayLinestringSupported()) {
            LOG.fine("Running pre-load linestring SQL statements.");
            for (i = 0; i < PRE_LOAD_SQL_WAY_LINESTRING.length; ++i) {
                LOG.finer("SQL: " + PRE_LOAD_SQL_WAY_LINESTRING[i]);
                this.jdbcTemplate.update(PRE_LOAD_SQL_WAY_LINESTRING[i]);
            }
        }
        LOG.fine("Pre-load SQL statements complete.");
    }

    public void completeAfterLoad() {
        int i;
        LOG.fine("Running post-load SQL.");
        for (i = 0; i < POST_LOAD_SQL.length; ++i) {
            LOG.finer("SQL: " + POST_LOAD_SQL[i]);
            this.jdbcTemplate.update(POST_LOAD_SQL[i]);
        }
        if (this.capabilityChecker.isWayBboxSupported()) {
            LOG.fine("Running post-load bbox SQL statements.");
            if (this.populateBbox) {
                LOG.finer("SQL: UPDATE ways SET bbox = (SELECT ST_Envelope(ST_Collect(geom)) FROM nodes JOIN way_nodes ON way_nodes.node_id = nodes.id WHERE way_nodes.way_id = ways.id)");
                this.jdbcTemplate.update(POST_LOAD_SQL_POPULATE_WAY_BBOX);
            }
            for (i = 0; i < POST_LOAD_SQL_WAY_BBOX.length; ++i) {
                LOG.finer("SQL: " + POST_LOAD_SQL_WAY_BBOX[i]);
                this.jdbcTemplate.update(POST_LOAD_SQL_WAY_BBOX[i]);
            }
        }
        if (this.capabilityChecker.isWayLinestringSupported()) {
            LOG.fine("Running post-load linestring SQL statements.");
            if (this.populateLinestring) {
                LOG.finer("SQL: UPDATE ways w SET linestring = (SELECT ST_MakeLine(c.geom) AS way_line FROM (SELECT n.geom AS geom FROM nodes n INNER JOIN way_nodes wn ON n.id = wn.node_id WHERE (wn.way_id = w.id) ORDER BY wn.sequence_id) c)");
                this.jdbcTemplate.update(POST_LOAD_SQL_POPULATE_WAY_LINESTRING);
            }
            for (i = 0; i < POST_LOAD_SQL_WAY_LINESTRING.length; ++i) {
                LOG.finer("SQL: " + POST_LOAD_SQL_WAY_LINESTRING[i]);
                this.jdbcTemplate.update(POST_LOAD_SQL_WAY_LINESTRING[i]);
            }
        }
    }
}

