/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.v0_6.impl;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.openstreetmap.osmosis.core.database.FeaturePopulator;
import org.openstreetmap.osmosis.core.database.SortingStoreRowMapperListener;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.lifecycle.Releasable;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableContainer;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.sort.common.FileBasedSort;
import org.openstreetmap.osmosis.core.sort.v0_6.EntityByTypeThenIdComparator;
import org.openstreetmap.osmosis.core.sort.v0_6.EntitySubClassComparator;
import org.openstreetmap.osmosis.core.store.ObjectSerializationFactory;
import org.openstreetmap.osmosis.core.store.SingleClassObjectSerializationFactory;
import org.openstreetmap.osmosis.core.store.StoreReleasingIterator;
import org.openstreetmap.osmosis.pgsnapshot.common.NoSuchRecordException;
import org.openstreetmap.osmosis.pgsnapshot.common.RowMapperRowCallbackListener;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.ActionDao;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.ChangesetAction;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.EntityMapper;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.EntityReader;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public abstract class EntityDao<T extends Entity> {
    private JdbcTemplate jdbcTemplate;
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private ActionDao actionDao;
    private EntityMapper<T> entityMapper;

    protected EntityDao(JdbcTemplate jdbcTemplate, EntityMapper<T> entityMapper, ActionDao actionDao) {
        this.jdbcTemplate = jdbcTemplate;
        this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate);
        this.entityMapper = entityMapper;
        this.actionDao = actionDao;
    }

    protected EntityMapper<T> getEntityMapper() {
        return this.entityMapper;
    }

    public boolean exists(long entityId) {
        return this.jdbcTemplate.queryForInt(this.entityMapper.getSqlSelectCount(true), new Object[]{entityId}) > 0;
    }

    public T getEntity(long entityId) {
        Entity entity;
        try {
            entity = (Entity)this.jdbcTemplate.queryForObject(this.entityMapper.getSqlSelect(true, false), this.entityMapper.getRowMapper(), new Object[]{entityId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new NoSuchRecordException(this.entityMapper.getEntityName() + " " + entityId + " doesn't exist.", e);
        }
        return (T)entity;
    }

    public void addEntity(T entity) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        this.entityMapper.populateEntityParameters(args, entity);
        this.namedParameterJdbcTemplate.update(this.entityMapper.getSqlInsert(1), args);
        this.actionDao.addAction(this.entityMapper.getEntityType(), ChangesetAction.CREATE, entity.getId());
    }

    public void modifyEntity(T entity) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        this.entityMapper.populateEntityParameters(args, entity);
        this.namedParameterJdbcTemplate.update(this.entityMapper.getSqlUpdate(true), args);
        this.actionDao.addAction(this.entityMapper.getEntityType(), ChangesetAction.MODIFY, entity.getId());
    }

    public void removeEntity(long entityId) {
        HashMap<String, Long> args = new HashMap<String, Long>();
        args.put("id", entityId);
        this.namedParameterJdbcTemplate.update(this.entityMapper.getSqlDelete(true), args);
        this.actionDao.addAction(this.entityMapper.getEntityType(), ChangesetAction.DELETE, entityId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReleasableIterator<T> getFeaturelessEntity(String tablePrefix) {
        FileBasedSort sortingStore = new FileBasedSort((ObjectSerializationFactory)new SingleClassObjectSerializationFactory(this.entityMapper.getEntityClass()), (Comparator)new EntitySubClassComparator((Comparator)new EntityByTypeThenIdComparator()), true);
        try {
            String sql = this.entityMapper.getSqlSelect(tablePrefix, false, false);
            SortingStoreRowMapperListener storeListener = new SortingStoreRowMapperListener(sortingStore);
            RowMapperRowCallbackListener<T> rowCallbackListener = new RowMapperRowCallbackListener<T>(this.entityMapper.getRowMapper(), storeListener);
            this.jdbcTemplate.query(sql, rowCallbackListener);
            StoreReleasingIterator resultIterator = new StoreReleasingIterator(sortingStore.iterate(), (Releasable)sortingStore);
            sortingStore = null;
            StoreReleasingIterator storeReleasingIterator = resultIterator;
            return storeReleasingIterator;
        }
        finally {
            if (sortingStore != null) {
                sortingStore.release();
            }
        }
    }

    protected abstract List<FeaturePopulator<T>> getFeaturePopulators(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReleasableIterator<T> iterate(String tablePrefix) {
        ReleasableContainer releasableContainer = new ReleasableContainer();
        try {
            EntityReader<T> entityIterator = (EntityReader<T>)releasableContainer.add(this.getFeaturelessEntity(tablePrefix));
            List<FeaturePopulator<T>> featurePopulators = this.getFeaturePopulators(tablePrefix);
            for (FeaturePopulator<T> featurePopulator : featurePopulators) {
                releasableContainer.add(featurePopulator);
            }
            entityIterator = new EntityReader<T>(entityIterator, featurePopulators);
            releasableContainer.clear();
            EntityReader<T> entityReader = entityIterator;
            return entityReader;
        }
        finally {
            releasableContainer.release();
        }
    }

    public ReleasableIterator<T> iterate() {
        return this.iterate("");
    }
}

