/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.v0_6;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSink;
import org.openstreetmap.osmosis.core.task.v0_6.RunnableChangeSource;
import org.openstreetmap.osmosis.xml.common.CompressionActivator;
import org.openstreetmap.osmosis.xml.common.CompressionMethod;
import org.openstreetmap.osmosis.xml.v0_6.XmlReader;
import org.openstreetmap.osmosis.xml.v0_6.impl.OsmChangeHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlChangeReader
implements RunnableChangeSource {
    private static Logger log = Logger.getLogger(XmlReader.class.getName());
    private ChangeSink changeSink;
    private File file;
    private boolean enableDateParsing;
    private CompressionMethod compressionMethod;

    public XmlChangeReader(File file, boolean enableDateParsing, CompressionMethod compressionMethod) {
        this.file = file;
        this.enableDateParsing = enableDateParsing;
        this.compressionMethod = compressionMethod;
    }

    public void setChangeSink(ChangeSink changeSink) {
        this.changeSink = changeSink;
    }

    private SAXParser createParser() {
        try {
            return SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new OsmosisRuntimeException("Unable to create SAX Parser.", (Throwable)e);
        }
        catch (SAXException e) {
            throw new OsmosisRuntimeException("Unable to create SAX Parser.", (Throwable)e);
        }
    }

    public void run() {
        InputStream inputStream = null;
        try {
            this.changeSink.initialize(Collections.emptyMap());
            inputStream = this.file.getName().equals("-") ? System.in : new FileInputStream(this.file);
            inputStream = new CompressionActivator(this.compressionMethod).createCompressionInputStream(inputStream);
            SAXParser parser = this.createParser();
            parser.parse(inputStream, (DefaultHandler)new OsmChangeHandler(this.changeSink, this.enableDateParsing));
            this.changeSink.complete();
        }
        catch (SAXParseException e) {
            throw new OsmosisRuntimeException("Unable to parse xml file " + this.file + ".  publicId=(" + e.getPublicId() + "), systemId=(" + e.getSystemId() + "), lineNumber=" + e.getLineNumber() + ", columnNumber=" + e.getColumnNumber() + ".", (Throwable)e);
        }
        catch (SAXException e) {
            throw new OsmosisRuntimeException("Unable to parse XML.", (Throwable)e);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to read XML file " + this.file + ".", (Throwable)e);
        }
        finally {
            this.changeSink.release();
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "Unable to close input stream.", e);
                }
                inputStream = null;
            }
        }
    }
}

