/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.queue;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.queue.BlockingReadTimeoutException;
import org.jboss.netty.util.internal.DeadLockProofWorker;
import org.jboss.netty.util.internal.LinkedTransferQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingReadHandler<E>
extends SimpleChannelUpstreamHandler {
    private final BlockingQueue<ChannelEvent> queue;
    private volatile boolean closed;

    public BlockingReadHandler() {
        this(new LinkedTransferQueue<ChannelEvent>());
    }

    public BlockingReadHandler(BlockingQueue<ChannelEvent> queue) {
        if (queue == null) {
            throw new NullPointerException("queue");
        }
        this.queue = queue;
    }

    protected BlockingQueue<ChannelEvent> getQueue() {
        return this.queue;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public E read() throws IOException, InterruptedException {
        ChannelEvent e = this.readEvent();
        if (e == null) {
            return null;
        }
        if (e instanceof MessageEvent) {
            return this.getMessage((MessageEvent)e);
        }
        if (e instanceof ExceptionEvent) {
            throw (IOException)new IOException().initCause(((ExceptionEvent)e).getCause());
        }
        throw new IllegalStateException();
    }

    public E read(long timeout, TimeUnit unit) throws IOException, InterruptedException {
        ChannelEvent e = this.readEvent(timeout, unit);
        if (e == null) {
            return null;
        }
        if (e instanceof MessageEvent) {
            return this.getMessage((MessageEvent)e);
        }
        if (e instanceof ExceptionEvent) {
            throw (IOException)new IOException().initCause(((ExceptionEvent)e).getCause());
        }
        throw new IllegalStateException();
    }

    public ChannelEvent readEvent() throws InterruptedException {
        this.detectDeadLock();
        if (this.isClosed() && this.getQueue().isEmpty()) {
            return null;
        }
        ChannelEvent e = this.getQueue().take();
        if (e instanceof ChannelStateEvent) {
            assert (this.closed);
            return null;
        }
        return e;
    }

    public ChannelEvent readEvent(long timeout, TimeUnit unit) throws InterruptedException, BlockingReadTimeoutException {
        this.detectDeadLock();
        if (this.isClosed() && this.getQueue().isEmpty()) {
            return null;
        }
        ChannelEvent e = this.getQueue().poll(timeout, unit);
        if (e == null) {
            throw new BlockingReadTimeoutException();
        }
        if (e instanceof ChannelStateEvent) {
            assert (this.closed);
            return null;
        }
        return e;
    }

    private void detectDeadLock() {
        if (DeadLockProofWorker.PARENT.get() != null) {
            throw new IllegalStateException("read*(...) in I/O thread causes a dead lock or sudden performance drop. Implement a state machine or call read*() from a different thread.");
        }
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        this.getQueue().put(e);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        this.getQueue().put(e);
    }

    @Override
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.closed = true;
        this.getQueue().put(e);
    }

    private E getMessage(MessageEvent e) {
        return (E)e.getMessage();
    }
}

