/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.time;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.time.FallbackDateParser;

public class DateParser {
    private DatatypeFactory datatypeFactory;
    private FallbackDateParser fallbackDateParser;
    private Calendar calendar;

    public DateParser() {
        try {
            this.datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new OsmosisRuntimeException("Unable to instantiate xml datatype factory.", e);
        }
        this.fallbackDateParser = new FallbackDateParser();
        this.calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
    }

    private boolean isDateInShortStandardFormat(String date) {
        int i;
        if (date.length() != 20) {
            return false;
        }
        char[] dateChars = date.toCharArray();
        if (dateChars[4] != '-') {
            return false;
        }
        if (dateChars[7] != '-') {
            return false;
        }
        if (dateChars[10] != 'T') {
            return false;
        }
        if (dateChars[13] != ':') {
            return false;
        }
        if (dateChars[16] != ':') {
            return false;
        }
        if (dateChars[19] != 'Z') {
            return false;
        }
        for (i = 0; i < 4; ++i) {
            if (dateChars[i] >= '0' && dateChars[i] <= '9') continue;
            return false;
        }
        for (i = 5; i < 7; ++i) {
            if (dateChars[i] >= '0' && dateChars[i] <= '9') continue;
            return false;
        }
        for (i = 8; i < 10; ++i) {
            if (dateChars[i] >= '0' && dateChars[i] <= '9') continue;
            return false;
        }
        for (i = 11; i < 13; ++i) {
            if (dateChars[i] >= '0' && dateChars[i] <= '9') continue;
            return false;
        }
        for (i = 14; i < 16; ++i) {
            if (dateChars[i] >= '0' && dateChars[i] <= '9') continue;
            return false;
        }
        for (i = 17; i < 19; ++i) {
            if (dateChars[i] >= '0' && dateChars[i] <= '9') continue;
            return false;
        }
        return true;
    }

    private boolean isDateInLongStandardFormat(String date) {
        int i;
        if (date.length() != 24) {
            return false;
        }
        char[] dateChars = date.toCharArray();
        if (dateChars[4] != '-') {
            return false;
        }
        if (dateChars[7] != '-') {
            return false;
        }
        if (dateChars[10] != 'T') {
            return false;
        }
        if (dateChars[13] != ':') {
            return false;
        }
        if (dateChars[16] != ':') {
            return false;
        }
        if (dateChars[19] != '.') {
            return false;
        }
        if (dateChars[23] != 'Z') {
            return false;
        }
        for (i = 0; i < 4; ++i) {
            if (dateChars[i] >= '0' && dateChars[i] <= '9') continue;
            return false;
        }
        for (i = 5; i < 7; ++i) {
            if (dateChars[i] >= '0' && dateChars[i] <= '9') continue;
            return false;
        }
        for (i = 8; i < 10; ++i) {
            if (dateChars[i] >= '0' && dateChars[i] <= '9') continue;
            return false;
        }
        for (i = 11; i < 13; ++i) {
            if (dateChars[i] >= '0' && dateChars[i] <= '9') continue;
            return false;
        }
        for (i = 14; i < 16; ++i) {
            if (dateChars[i] >= '0' && dateChars[i] <= '9') continue;
            return false;
        }
        for (i = 17; i < 19; ++i) {
            if (dateChars[i] >= '0' && dateChars[i] <= '9') continue;
            return false;
        }
        for (i = 20; i < 23; ++i) {
            if (dateChars[i] >= '0' && dateChars[i] <= '9') continue;
            return false;
        }
        return true;
    }

    private Date parseShortStandardDate(String date) {
        int year = Integer.parseInt(date.substring(0, 4));
        int month = Integer.parseInt(date.substring(5, 7));
        int day = Integer.parseInt(date.substring(8, 10));
        int hour = Integer.parseInt(date.substring(11, 13));
        int minute = Integer.parseInt(date.substring(14, 16));
        int second = Integer.parseInt(date.substring(17, 19));
        this.calendar.clear();
        this.calendar.set(1, year);
        this.calendar.set(2, month - 1);
        this.calendar.set(5, day);
        this.calendar.set(11, hour);
        this.calendar.set(12, minute);
        this.calendar.set(13, second);
        return this.calendar.getTime();
    }

    private Date parseLongStandardDate(String date) {
        int year = Integer.parseInt(date.substring(0, 4));
        int month = Integer.parseInt(date.substring(5, 7));
        int day = Integer.parseInt(date.substring(8, 10));
        int hour = Integer.parseInt(date.substring(11, 13));
        int minute = Integer.parseInt(date.substring(14, 16));
        int second = Integer.parseInt(date.substring(17, 19));
        int millisecond = Integer.parseInt(date.substring(20, 23));
        this.calendar.clear();
        this.calendar.set(1, year);
        this.calendar.set(2, month - 1);
        this.calendar.set(5, day);
        this.calendar.set(11, hour);
        this.calendar.set(12, minute);
        this.calendar.set(13, second);
        this.calendar.set(14, millisecond);
        return this.calendar.getTime();
    }

    public Date parse(String date) {
        try {
            if (this.isDateInShortStandardFormat(date)) {
                return this.parseShortStandardDate(date);
            }
            if (this.isDateInLongStandardFormat(date)) {
                return this.parseLongStandardDate(date);
            }
            return this.datatypeFactory.newXMLGregorianCalendar(date).toGregorianCalendar().getTime();
        }
        catch (IllegalArgumentException e) {
            return this.fallbackDateParser.parse(date);
        }
    }
}

