/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.store;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.LinkedList;
import java.util.List;

public class BufferedRandomAccessFileInputStream
extends InputStream {
    private static final int DEFAULT_BUFFER_COUNT = 4;
    private static final int DEFAULT_INITIAL_BUFFER_SIZE = 16;
    private static final int DEFAULT_MAXIMUM_BUFFER_SIZE = 4096;
    private static final float DEFAULT_BUFFER_INCREASE_FACTOR = 2.0f;
    private RandomAccessFile randomFile;
    private int bufferCount;
    private List<BufferedReader> readerList;

    public BufferedRandomAccessFileInputStream(File file) throws FileNotFoundException {
        this(file, 4, 16, 4096, 2.0f);
    }

    public BufferedRandomAccessFileInputStream(File file, int bufferCount, int initialBufferSize, int maxBufferSize, float bufferIncreaseFactor) throws FileNotFoundException {
        this.bufferCount = bufferCount;
        this.randomFile = new RandomAccessFile(file, "r");
        this.readerList = new LinkedList<BufferedReader>();
        for (int i = 0; i < bufferCount; ++i) {
            this.readerList.add(new BufferedReader(this.randomFile, initialBufferSize, maxBufferSize, bufferIncreaseFactor));
        }
    }

    @Override
    public int read() throws IOException {
        return this.readerList.get(0).read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.readerList.get(0).read(b, off, len);
    }

    public void seek(long pos) throws IOException {
        BufferedReader reader = null;
        for (int i = 0; i < this.bufferCount; ++i) {
            BufferedReader tmpReader = this.readerList.get(i);
            if (!tmpReader.containsPosition(pos)) continue;
            reader = tmpReader;
            if (i <= 0) break;
            this.readerList.remove(i);
            this.readerList.add(0, reader);
            break;
        }
        if (reader == null) {
            reader = this.readerList.remove(this.bufferCount - 1);
            this.readerList.add(0, reader);
        }
        reader.seek(pos);
    }

    public long length() throws IOException {
        return this.randomFile.length();
    }

    public long position() throws IOException {
        return this.readerList.get(0).position();
    }

    @Override
    public void close() throws IOException {
        this.randomFile.close();
    }

    private static class BufferedReader {
        private RandomAccessFile randomFile;
        private int initialBufferSize;
        private int maxBufferSize;
        private float bufferIncreaseFactor;
        private byte[] buffer;
        private long bufferFilePosition;
        private int currentBufferSize;
        private int currentBufferByteCount;
        private int currentBufferOffset;

        public BufferedReader(RandomAccessFile randomFile, int initialBufferSize, int maxBufferSize, float bufferIncreaseFactor) {
            this.randomFile = randomFile;
            this.initialBufferSize = initialBufferSize;
            this.maxBufferSize = maxBufferSize;
            this.bufferIncreaseFactor = bufferIncreaseFactor;
            this.buffer = new byte[maxBufferSize];
            this.bufferFilePosition = 0L;
            this.currentBufferSize = 0;
            this.currentBufferByteCount = 0;
            this.currentBufferOffset = 0;
        }

        public long position() throws IOException {
            return this.bufferFilePosition + (long)this.currentBufferOffset;
        }

        public boolean containsPosition(long position) {
            return position >= this.bufferFilePosition && position < this.bufferFilePosition + (long)this.maxBufferSize;
        }

        public void seek(long pos) throws IOException {
            long bufferBeginFileOffset = this.bufferFilePosition;
            long bufferEndFileOffset = this.bufferFilePosition + (long)this.currentBufferByteCount;
            if (pos >= bufferBeginFileOffset && pos <= bufferEndFileOffset) {
                this.currentBufferOffset = (int)(pos - bufferBeginFileOffset);
            } else if (pos < bufferBeginFileOffset && bufferBeginFileOffset - pos <= (long)this.maxBufferSize) {
                this.randomFile.seek(pos);
                this.bufferFilePosition = pos;
                this.currentBufferByteCount = 0;
            } else if (pos > bufferEndFileOffset && pos - bufferEndFileOffset <= (long)this.maxBufferSize) {
                this.randomFile.seek(pos);
                this.bufferFilePosition = pos;
                this.currentBufferByteCount = 0;
            } else {
                this.randomFile.seek(pos);
                this.bufferFilePosition = pos;
                this.currentBufferSize = 0;
                this.currentBufferByteCount = 0;
                this.currentBufferOffset = 0;
            }
        }

        private boolean populateBuffer() throws IOException {
            if (this.currentBufferOffset >= this.currentBufferByteCount) {
                if (this.randomFile.getFilePointer() != this.bufferFilePosition + (long)this.currentBufferByteCount) {
                    this.randomFile.seek(this.bufferFilePosition + (long)this.currentBufferByteCount);
                }
                this.bufferFilePosition += (long)this.currentBufferByteCount;
                this.currentBufferOffset = 0;
                if (this.currentBufferSize == 0) {
                    this.currentBufferSize = this.initialBufferSize;
                } else if (this.currentBufferSize < this.maxBufferSize) {
                    this.currentBufferSize = (int)((float)this.currentBufferSize * this.bufferIncreaseFactor);
                    if (this.currentBufferSize > this.maxBufferSize) {
                        this.currentBufferSize = this.maxBufferSize;
                    }
                }
                this.currentBufferByteCount = this.randomFile.read(this.buffer, 0, this.currentBufferSize);
                if (this.currentBufferByteCount < 0) {
                    return false;
                }
            }
            return true;
        }

        public int read() throws IOException {
            if (this.populateBuffer()) {
                return this.buffer[this.currentBufferOffset++] & 0xFF;
            }
            return -1;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.populateBuffer()) {
                int readLength = this.currentBufferByteCount - this.currentBufferOffset;
                if (readLength > len) {
                    readLength = len;
                }
                System.arraycopy(this.buffer, this.currentBufferOffset, b, off, readLength);
                this.currentBufferOffset += readLength;
                return readLength;
            }
            return -1;
        }
    }
}

