/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.filter.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.openstreetmap.osmosis.core.filter.common.DynamicIdTrackerSegment;
import org.openstreetmap.osmosis.core.filter.common.IdTracker;

public class DynamicIdTracker
implements IdTracker {
    static final int SEGMENT_SIZE = 1024;
    private List<DynamicIdTrackerSegment> segments = new ArrayList<DynamicIdTrackerSegment>();

    private int calculateOffset(long id) {
        int offset = (int)(id % 1024L);
        if (offset < 0) {
            offset = 1024 + offset;
        }
        return offset;
    }

    private DynamicIdTrackerSegment getSegment(long base, boolean createIfMissing) {
        DynamicIdTrackerSegment segment = null;
        int intervalBegin = 0;
        int intervalEnd = this.segments.size();
        boolean searchComplete = false;
        while (!searchComplete) {
            long currentBase;
            DynamicIdTrackerSegment currentSegment;
            int intervalSize = intervalEnd - intervalBegin;
            if (intervalSize == 0) {
                if (createIfMissing) {
                    segment = new DynamicIdTrackerSegment(base);
                    this.segments.add(intervalBegin, segment);
                }
                searchComplete = true;
                continue;
            }
            if (intervalSize >= 2) {
                int intervalMid = intervalSize / 2 + intervalBegin;
                currentSegment = this.segments.get(intervalMid);
                currentBase = currentSegment.getBase();
                if (currentBase == base) {
                    segment = currentSegment;
                    searchComplete = true;
                    continue;
                }
                if (currentBase < base) {
                    intervalBegin = intervalMid + 1;
                    continue;
                }
                intervalEnd = intervalMid;
                continue;
            }
            while (intervalBegin < intervalEnd) {
                currentSegment = this.segments.get(intervalBegin);
                currentBase = currentSegment.getBase();
                if (currentBase == base) {
                    segment = currentSegment;
                    break;
                }
                if (currentBase > base) {
                    if (!createIfMissing) break;
                    segment = new DynamicIdTrackerSegment(base);
                    this.segments.add(intervalBegin, segment);
                    break;
                }
                ++intervalBegin;
            }
            if (segment == null && createIfMissing) {
                segment = new DynamicIdTrackerSegment(base);
                this.segments.add(intervalBegin, segment);
            }
            searchComplete = true;
        }
        return segment;
    }

    @Override
    public boolean get(long id) {
        int offset = this.calculateOffset(id);
        long base = id - (long)offset;
        DynamicIdTrackerSegment segment = this.getSegment(base, false);
        if (segment != null) {
            return segment.get(offset);
        }
        return false;
    }

    @Override
    public void set(long id) {
        int offset = this.calculateOffset(id);
        long base = id - (long)offset;
        DynamicIdTrackerSegment segment = this.getSegment(base, true);
        segment.set(offset);
    }

    @Override
    public void setAll(IdTracker idTracker) {
        for (Long id : idTracker) {
            this.set(id);
        }
    }

    @Override
    public Iterator<Long> iterator() {
        return new SegmentIdIterator(this.segments.iterator());
    }

    private static class SegmentIdIterator
    implements Iterator<Long> {
        private Iterator<DynamicIdTrackerSegment> segments;
        private Iterator<Long> currentSegmentIds;
        private long currentSegmentBase;

        public SegmentIdIterator(Iterator<DynamicIdTrackerSegment> segments) {
            this.segments = segments;
        }

        @Override
        public boolean hasNext() {
            while (true) {
                if (this.currentSegmentIds == null) {
                    if (this.segments.hasNext()) {
                        DynamicIdTrackerSegment segment = this.segments.next();
                        this.currentSegmentIds = segment.iterator();
                        this.currentSegmentBase = segment.getBase();
                    } else {
                        return false;
                    }
                }
                if (this.currentSegmentIds.hasNext()) {
                    return true;
                }
                this.currentSegmentIds = null;
            }
        }

        @Override
        public Long next() {
            if (this.hasNext()) {
                return this.currentSegmentIds.next() + this.currentSegmentBase;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

