/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.v0_6.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.ActionDataType;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.EntityMapper;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.WayNodesArray;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.WayRowMapper;
import org.springframework.jdbc.core.RowMapper;

public class WayMapper
extends EntityMapper<Way> {
    private boolean supportBboxColumn;
    private boolean supportLinestringColumn;

    public WayMapper() {
        this.supportBboxColumn = false;
    }

    public WayMapper(boolean supportBboxColumn, boolean supportLinestringColumn) {
        this.supportBboxColumn = supportBboxColumn;
        this.supportLinestringColumn = supportLinestringColumn;
    }

    @Override
    public String getEntityName() {
        return "way";
    }

    @Override
    public ActionDataType getEntityType() {
        return ActionDataType.WAY;
    }

    @Override
    public Class<Way> getEntityClass() {
        return Way.class;
    }

    @Override
    protected String[] getTypeSpecificFieldNames() {
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add("nodes");
        if (this.supportBboxColumn) {
            fieldNames.add("bbox");
        }
        if (this.supportLinestringColumn) {
            fieldNames.add("linestring");
        }
        return fieldNames.toArray(new String[0]);
    }

    @Override
    public void populateEntityParameters(Map<String, Object> args, Way entity) {
        this.populateCommonEntityParameters(args, (Entity)entity);
        List wayNodes = entity.getWayNodes();
        long[] nodeIds = new long[wayNodes.size()];
        for (int i = 0; i < nodeIds.length; ++i) {
            nodeIds[i] = ((WayNode)wayNodes.get(i)).getNodeId();
        }
        args.put("nodes", new WayNodesArray(nodeIds));
    }

    @Override
    public RowMapper<Way> getRowMapper() {
        return new WayRowMapper();
    }
}

