/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.tagtransform.impl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.domain.common.TimestampFormat;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.lifecycle.Completable;
import org.openstreetmap.osmosis.core.lifecycle.Releasable;
import org.openstreetmap.osmosis.core.task.common.Task;
import org.openstreetmap.osmosis.core.task.v0_6.Initializable;
import org.openstreetmap.osmosis.tagtransform.Match;
import org.openstreetmap.osmosis.tagtransform.Output;
import org.openstreetmap.osmosis.tagtransform.StatsSaveException;
import org.openstreetmap.osmosis.tagtransform.TTEntityType;
import org.openstreetmap.osmosis.tagtransform.Translation;
import org.openstreetmap.osmosis.tagtransform.impl.TransformLoader;
import org.openstreetmap.osmosis.xml.common.XmlTimestampFormat;

public abstract class TransformHelper<T extends Task & Initializable>
implements Initializable {
    protected Logger logger = Logger.getLogger(this.getClass().getName());
    protected T sink;
    protected String statsFile;
    protected String configFile;
    protected List<Translation> translations;
    protected static TimestampFormat timestampFormat = new XmlTimestampFormat();

    public TransformHelper(String configFile, String statsFile) {
        this.logger.log(Level.FINE, "Transform configured with " + configFile + " and " + statsFile);
        this.translations = new TransformLoader().load(configFile);
        this.statsFile = statsFile;
        this.configFile = configFile;
    }

    public void initialize(Map<String, Object> metaData) {
        ((Initializable)this.sink).initialize(metaData);
    }

    public void setSink(T sink) {
        this.sink = sink;
    }

    public void complete() {
        if (this.statsFile != null && !this.statsFile.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.configFile);
            builder.append("\n\n");
            for (Translation t : this.translations) {
                t.outputStats(builder, "");
            }
            Writer writer = null;
            try {
                writer = new FileWriter(new File(this.statsFile));
                writer.write(builder.toString());
            }
            catch (IOException e) {
                throw new StatsSaveException("Failed to save stats: " + e.getLocalizedMessage(), e);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        this.logger.log(Level.WARNING, "Unable to close stats file " + this.statsFile + ".", e);
                    }
                }
            }
        }
        ((Completable)this.sink).complete();
    }

    public void release() {
        ((Releasable)this.sink).release();
    }

    protected EntityContainer processEntityContainer(EntityContainer entityContainer) {
        EntityContainer writeableEntityContainer = entityContainer.getWriteableInstance();
        Entity entity = entityContainer.getEntity();
        Collection entityTags = entity.getTags();
        EntityType entityType = entity.getType();
        HashMap<String, String> tagMap = new HashMap<String, String>();
        for (Tag tag : entity.getTags()) {
            tagMap.put(tag.getKey(), tag.getValue());
        }
        for (Translation translation : this.translations) {
            Collection<Match> matches = translation.match(tagMap, TTEntityType.fromEntityType06(entityType), entity.getUser().getName(), entity.getUser().getId());
            if (matches == null || matches.isEmpty()) continue;
            if (translation.isDropOnMatch()) {
                return null;
            }
            HashMap<String, String> newTags = new HashMap<String, String>();
            for (Output output : translation.getOutputs()) {
                output.apply(tagMap, newTags, matches);
            }
            tagMap = newTags;
        }
        entityTags.clear();
        for (Map.Entry entry : tagMap.entrySet()) {
            entityTags.add(new Tag((String)entry.getKey(), (String)entry.getValue()));
        }
        return writeableEntityContainer;
    }
}

