/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.set.v0_6;

import java.util.Collections;
import java.util.Comparator;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.merge.common.ConflictResolutionMethod;
import org.openstreetmap.osmosis.core.sort.v0_6.EntityByTypeThenIdThenVersionComparator;
import org.openstreetmap.osmosis.core.sort.v0_6.EntityContainerComparator;
import org.openstreetmap.osmosis.core.sort.v0_6.SortedHistoryChangePipeValidator;
import org.openstreetmap.osmosis.core.store.DataPostbox;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSink;
import org.openstreetmap.osmosis.core.task.v0_6.MultiChangeSinkRunnableChangeSource;
import org.openstreetmap.osmosis.set.v0_6.impl.DataPostboxChangeSink;

public class ChangeMerger
implements MultiChangeSinkRunnableChangeSource {
    private ChangeSink changeSink;
    private DataPostbox<ChangeContainer> postbox0;
    private SortedHistoryChangePipeValidator sortedChangeValidator0;
    private DataPostbox<ChangeContainer> postbox1;
    private SortedHistoryChangePipeValidator sortedChangeValidator1;
    private ConflictResolutionMethod conflictResolutionMethod;

    public ChangeMerger(ConflictResolutionMethod conflictResolutionMethod, int inputBufferCapacity) {
        this.conflictResolutionMethod = conflictResolutionMethod;
        this.postbox0 = new DataPostbox(inputBufferCapacity);
        this.sortedChangeValidator0 = new SortedHistoryChangePipeValidator();
        this.sortedChangeValidator0.setChangeSink((ChangeSink)new DataPostboxChangeSink(this.postbox0));
        this.postbox1 = new DataPostbox(inputBufferCapacity);
        this.sortedChangeValidator1 = new SortedHistoryChangePipeValidator();
        this.sortedChangeValidator1.setChangeSink((ChangeSink)new DataPostboxChangeSink(this.postbox1));
    }

    public ChangeSink getChangeSink(int instance) {
        switch (instance) {
            case 0: {
                return this.sortedChangeValidator0;
            }
            case 1: {
                return this.sortedChangeValidator1;
            }
        }
        throw new OsmosisRuntimeException("Sink instance " + instance + " is not valid.");
    }

    public int getChangeSinkCount() {
        return 2;
    }

    public void setChangeSink(ChangeSink changeSink) {
        this.changeSink = changeSink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            ChangeContainer changeContainer0 = null;
            ChangeContainer changeContainer1 = null;
            EntityContainerComparator comparator = new EntityContainerComparator((Comparator)new EntityByTypeThenIdThenVersionComparator());
            this.postbox0.outputInitialize();
            this.postbox1.outputInitialize();
            this.changeSink.initialize(Collections.emptyMap());
            while ((changeContainer0 != null || this.postbox0.hasNext()) && (changeContainer1 != null || this.postbox1.hasNext())) {
                long comparisonResult;
                if (changeContainer0 == null) {
                    changeContainer0 = (ChangeContainer)this.postbox0.getNext();
                }
                if (changeContainer1 == null) {
                    changeContainer1 = (ChangeContainer)this.postbox1.getNext();
                }
                if ((comparisonResult = (long)comparator.compare(changeContainer0.getEntityContainer(), changeContainer1.getEntityContainer())) < 0L) {
                    this.changeSink.process(changeContainer0);
                    changeContainer0 = null;
                    continue;
                }
                if (comparisonResult > 0L) {
                    this.changeSink.process(changeContainer1);
                    changeContainer1 = null;
                    continue;
                }
                if (this.conflictResolutionMethod.equals((Object)ConflictResolutionMethod.Timestamp)) {
                    int timestampComparisonResult = changeContainer0.getEntityContainer().getEntity().getTimestamp().compareTo(changeContainer1.getEntityContainer().getEntity().getTimestamp());
                    if (timestampComparisonResult < 0) {
                        this.changeSink.process(changeContainer1);
                    } else if (timestampComparisonResult > 0) {
                        this.changeSink.process(changeContainer0);
                    } else {
                        this.changeSink.process(changeContainer1);
                    }
                } else if (this.conflictResolutionMethod.equals((Object)ConflictResolutionMethod.LatestSource)) {
                    this.changeSink.process(changeContainer1);
                } else if (this.conflictResolutionMethod.equals((Object)ConflictResolutionMethod.Version)) {
                    int version1;
                    int version0 = changeContainer0.getEntityContainer().getEntity().getVersion();
                    if (version0 < (version1 = changeContainer1.getEntityContainer().getEntity().getVersion())) {
                        this.changeSink.process(changeContainer1);
                    } else if (version0 > version1) {
                        this.changeSink.process(changeContainer0);
                    } else {
                        this.changeSink.process(changeContainer1);
                    }
                } else {
                    throw new OsmosisRuntimeException("Conflict resolution method " + this.conflictResolutionMethod + " is not recognized.");
                }
                changeContainer0 = null;
                changeContainer1 = null;
            }
            while (changeContainer0 != null || this.postbox0.hasNext()) {
                if (changeContainer0 == null) {
                    changeContainer0 = (ChangeContainer)this.postbox0.getNext();
                }
                this.changeSink.process(changeContainer0);
                changeContainer0 = null;
            }
            while (changeContainer1 != null || this.postbox1.hasNext()) {
                if (changeContainer1 == null) {
                    changeContainer1 = (ChangeContainer)this.postbox1.getNext();
                }
                this.changeSink.process(changeContainer1);
                changeContainer1 = null;
            }
            this.changeSink.complete();
            this.postbox0.outputComplete();
            this.postbox1.outputComplete();
        }
        finally {
            this.changeSink.release();
            this.postbox0.outputRelease();
            this.postbox1.outputRelease();
        }
    }
}

