/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replicationhttp.v0_6.impl;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.replicationhttp.v0_6.impl.SequenceClient;
import org.openstreetmap.osmosis.replicationhttp.v0_6.impl.SequenceClientControl;

public class SequenceClientRestartManager {
    private static final Logger LOG = Logger.getLogger(SequenceClientRestartManager.class.getName());
    private static final int RESTART_DELAY = 60000;
    private Lock controlLock = new ReentrantLock();
    private Condition controlCondition = this.controlLock.newCondition();
    private ClientControl control = new ClientControl();
    private boolean clientRunning;

    private void waitForUpdate() {
        try {
            this.controlCondition.await();
        }
        catch (InterruptedException e) {
            throw new OsmosisRuntimeException("Thread was interrupted.", (Throwable)e);
        }
    }

    private void signalUpdate() {
        this.controlCondition.signal();
    }

    public SequenceClientControl getControl() {
        return this.control;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void manageClient(SequenceClient sequenceClient) {
        try {
            while (true) lbl-1000:
            // 2 sources

            {
                this.clientRunning = true;
                try {
                    sequenceClient.start();
                }
                catch (OsmosisRuntimeException e) {
                    SequenceClientRestartManager.LOG.warning("Unable to start the sequence client, will retry in 60000 milliseconds.");
                }
                try {
                    this.controlLock.lock();
                    while (this.clientRunning) {
                        this.waitForUpdate();
                    }
                }
                finally {
                    this.controlLock.unlock();
                }
                sequenceClient.stop();
                try {
                    Thread.sleep(60000L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new OsmosisRuntimeException("Thread sleep failed between sequence number client invocations", (Throwable)e);
                }
                break;
            }
        }
        catch (Throwable var4_5) {
            sequenceClient.stop();
            throw var4_5;
        }
        {
            ** while (true)
        }
    }

    private class ClientControl
    implements SequenceClientControl {
        private ClientControl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void channelClosed() {
            SequenceClientRestartManager.this.controlLock.lock();
            try {
                SequenceClientRestartManager.this.clientRunning = false;
                SequenceClientRestartManager.this.signalUpdate();
            }
            finally {
                SequenceClientRestartManager.this.controlLock.unlock();
            }
        }
    }
}

