/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replicationhttp.v0_6.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.util.CharsetUtil;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.lifecycle.Releasable;

public class ChunkedDataReceiver
implements Releasable {
    private static final Logger LOG = Logger.getLogger(ChunkedDataReceiver.class.getName());
    private ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
    private File tmpDataFile;
    private FileChannel tmpDataChannel;
    private List<File> readyFiles = new ArrayList<File>();
    private boolean chunkInProgress = false;
    private long bytesRemaining;

    private long getChunkLength() {
        for (int i = this.buffer.readerIndex() + 1; i < this.buffer.writerIndex(); ++i) {
            if (this.buffer.getByte(i) != 10 || this.buffer.getByte(i - 1) != 13) continue;
            String chunkSizeString = this.buffer.toString(this.buffer.readerIndex(), i - this.buffer.readerIndex() - 1, CharsetUtil.UTF_8);
            long chunkSize = Long.parseLong(chunkSizeString);
            this.buffer.readerIndex(i + 1);
            return chunkSize;
        }
        return -1L;
    }

    private void initializeChunk() {
        try {
            this.tmpDataFile = File.createTempFile("change", ".tmp");
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to create replication data temp file", (Throwable)e);
        }
        try {
            this.tmpDataChannel = new FileOutputStream(this.tmpDataFile).getChannel();
        }
        catch (FileNotFoundException e) {
            throw new OsmosisRuntimeException("Unable to open chunk data temp file", (Throwable)e);
        }
        this.chunkInProgress = true;
    }

    private void writeToChunk(ChannelBuffer writeBuffer) {
        try {
            int bytesToWrite = (int)Math.min((long)writeBuffer.readableBytes(), this.bytesRemaining);
            this.tmpDataChannel.write(writeBuffer.toByteBuffer(writeBuffer.readerIndex(), bytesToWrite));
            writeBuffer.skipBytes(bytesToWrite);
            this.bytesRemaining -= (long)bytesToWrite;
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to write chunk data to temp file", (Throwable)e);
        }
        if (this.bytesRemaining <= 0L) {
            try {
                this.tmpDataChannel.close();
            }
            catch (IOException e) {
                throw new OsmosisRuntimeException("Unable to close chunk data temp file", (Throwable)e);
            }
            this.readyFiles.add(this.tmpDataFile);
            this.tmpDataFile = null;
            this.chunkInProgress = false;
        }
    }

    private List<File> createResultFileList() {
        ArrayList<File> resultFiles = new ArrayList<File>(this.readyFiles);
        this.readyFiles.clear();
        return resultFiles;
    }

    public List<File> processData(ChannelBuffer inputBuffer) {
        while (inputBuffer.readableBytes() > 0 || this.buffer.readableBytes() > 0) {
            if (!this.chunkInProgress) {
                this.buffer.writeBytes(inputBuffer);
                this.bytesRemaining = this.getChunkLength();
                if (this.bytesRemaining >= 0L) {
                    this.initializeChunk();
                } else {
                    return this.createResultFileList();
                }
            }
            if (this.buffer.readableBytes() > 0) {
                this.writeToChunk(this.buffer);
                continue;
            }
            this.writeToChunk(inputBuffer);
        }
        return this.createResultFileList();
    }

    public ChannelBuffer getBuffer() {
        return this.buffer;
    }

    public void release() {
        if (this.tmpDataChannel != null) {
            try {
                this.tmpDataChannel.close();
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Unable to close the current temporary chunk file", ex);
            }
        }
        if (this.tmpDataFile != null && !this.tmpDataFile.delete()) {
            LOG.log(Level.WARNING, "Unable to delete the current temporary chunk file " + this.tmpDataFile);
        }
        for (File readyFile : this.readyFiles) {
            if (readyFile.delete()) continue;
            LOG.log(Level.WARNING, "Unable to delete the current temporary chunk file " + readyFile);
        }
        this.readyFiles.clear();
    }
}

