/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replication.v0_6;

import java.io.File;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.sort.v0_6.ChangeForStreamableApplierComparator;
import org.openstreetmap.osmosis.core.sort.v0_6.ChangeSorter;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSink;
import org.openstreetmap.osmosis.core.util.PropertiesPersister;
import org.openstreetmap.osmosis.replication.common.FileReplicationStore;
import org.openstreetmap.osmosis.replication.common.ReplicationState;
import org.openstreetmap.osmosis.replication.common.ReplicationStore;
import org.openstreetmap.osmosis.replication.v0_6.BaseReplicationDownloader;
import org.openstreetmap.osmosis.replication.v0_6.impl.ReplicationDownloaderConfiguration;
import org.openstreetmap.osmosis.replication.v0_6.impl.ReplicationFileMergerConfiguration;
import org.openstreetmap.osmosis.xml.v0_6.XmlChangeReader;
import org.openstreetmap.osmosis.xml.v0_6.XmlChangeWriter;

public class ReplicationFileMerger
extends BaseReplicationDownloader {
    private static final Logger LOG = Logger.getLogger(ReplicationFileMerger.class.getName());
    private static final String DATA_DIRECTORY = "data";
    private static final String CONFIG_FILE = "configuration.txt";
    private boolean sinkActive = false;
    private ChangeSink changeSink;
    private ReplicationState currentDataState;
    private PropertiesPersister dataStatePersister;
    private ReplicationStore replicationStore = new FileReplicationStore(new File(this.getWorkingDirectory(), "data"), true);

    public ReplicationFileMerger(File workingDirectory) {
        super(workingDirectory);
    }

    private Date alignDateToIntervalBoundary(Date requestedDate, long intervalLength) {
        long remainder = requestedDate.getTime() % intervalLength;
        if (remainder > 0L) {
            return new Date(requestedDate.getTime() - remainder);
        }
        return requestedDate;
    }

    @Override
    protected Date calculateMaximumTimestamp(ReplicationDownloaderConfiguration configuration, Date serverTimestamp, Date localTimestamp) {
        this.currentDataState = new ReplicationState(this.dataStatePersister.loadMap());
        Date maximumTimestamp = super.calculateMaximumTimestamp(configuration, serverTimestamp, localTimestamp);
        long intervalLength = this.getConfiguration().getIntervalLength();
        if (intervalLength > 0L) {
            maximumTimestamp = this.alignDateToIntervalBoundary(maximumTimestamp, intervalLength);
            if (this.currentDataState.getSequenceNumber() == 0L && maximumTimestamp.compareTo(this.currentDataState.getTimestamp()) <= 0) {
                maximumTimestamp = new Date(maximumTimestamp.getTime() - intervalLength);
            }
        }
        if (maximumTimestamp.compareTo(localTimestamp) > 0 && maximumTimestamp.compareTo(this.currentDataState.getTimestamp()) <= 0) {
            maximumTimestamp = localTimestamp;
        }
        LOG.finer("Maximum timestamp is " + maximumTimestamp);
        return maximumTimestamp;
    }

    private ChangeSink buildResultWriter(long sequenceNumber) {
        XmlChangeWriter xmlChangeWriter = this.replicationStore.saveData(sequenceNumber);
        ChangeSorter changeSorter = new ChangeSorter((Comparator)new ChangeForStreamableApplierComparator());
        changeSorter.setChangeSink((ChangeSink)xmlChangeWriter);
        return changeSorter;
    }

    private void writeChangeset(XmlChangeReader xmlReader) {
        final ChangeSink localChangeSink = this.changeSink;
        xmlReader.setChangeSink(new ChangeSink(){
            private ChangeSink suppressedWriter;
            {
                this.suppressedWriter = localChangeSink;
            }

            public void initialize(Map<String, Object> metaData) {
            }

            public void process(ChangeContainer change) {
                this.suppressedWriter.process(change);
            }

            public void complete() {
            }

            public void release() {
            }
        });
        xmlReader.run();
    }

    private ReplicationFileMergerConfiguration getConfiguration() {
        return new ReplicationFileMergerConfiguration(new File(this.getWorkingDirectory(), CONFIG_FILE));
    }

    @Override
    protected void processInitialize(Map<String, Object> metaData) {
    }

    @Override
    protected void processInitializeState(ReplicationState initialState) {
        long intervalLength = this.getConfiguration().getIntervalLength();
        Date initialDate = initialState.getTimestamp();
        Date alignedDate = this.alignDateToIntervalBoundary(initialDate, intervalLength);
        if (alignedDate.compareTo(initialDate) < 0) {
            alignedDate = new Date(alignedDate.getTime() + intervalLength);
        }
        this.currentDataState = new ReplicationState(alignedDate, 0L);
        this.replicationStore.saveState(this.currentDataState);
    }

    @Override
    protected void processChangeset(XmlChangeReader xmlReader, ReplicationState replicationState) {
        ReplicationFileMergerConfiguration configuration = this.getConfiguration();
        int intervalLength = configuration.getIntervalLength();
        if (!this.sinkActive) {
            this.currentDataState.setSequenceNumber(this.currentDataState.getSequenceNumber() + 1L);
            LOG.finer("Opening change sink for interval with sequence number " + this.currentDataState.getSequenceNumber());
            this.changeSink = this.buildResultWriter(this.currentDataState.getSequenceNumber());
        }
        if (intervalLength > 0) {
            if (!this.sinkActive) {
                Date intervalEnd = new Date(this.currentDataState.getTimestamp().getTime() + (long)intervalLength);
                intervalEnd = this.alignDateToIntervalBoundary(intervalEnd, intervalLength);
                this.currentDataState.setTimestamp(intervalEnd);
                LOG.finer("End of current interval is " + intervalEnd);
            }
            while (replicationState.getTimestamp().compareTo(this.currentDataState.getTimestamp()) > 0) {
                LOG.finer("Closing change sink for interval with sequence number " + this.currentDataState.getSequenceNumber());
                this.changeSink.complete();
                this.changeSink.release();
                this.replicationStore.saveState(this.currentDataState);
                this.currentDataState.setSequenceNumber(this.currentDataState.getSequenceNumber() + 1L);
                this.currentDataState.setTimestamp(new Date(this.currentDataState.getTimestamp().getTime() + (long)configuration.getIntervalLength()));
                LOG.finer("Opening change sink for interval with sequence number " + this.currentDataState.getSequenceNumber());
                this.changeSink = this.buildResultWriter(this.currentDataState.getSequenceNumber());
            }
        } else {
            LOG.finer("End of current interval is " + replicationState.getTimestamp());
            this.currentDataState.setTimestamp(replicationState.getTimestamp());
        }
        this.writeChangeset(xmlReader);
        this.sinkActive = true;
    }

    @Override
    protected void processComplete() {
        if (this.sinkActive) {
            LOG.finer("Closing change sink for interval with sequence number " + this.currentDataState.getSequenceNumber());
            this.changeSink.complete();
            this.replicationStore.saveState(this.currentDataState);
            this.changeSink.release();
            this.changeSink = null;
            this.sinkActive = false;
        }
    }

    @Override
    protected void processRelease() {
        if (this.sinkActive) {
            this.changeSink.release();
            this.sinkActive = false;
        }
    }
}

