/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replication.common;

import java.io.File;
import java.util.StringTokenizer;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.replication.common.ReplicationSequenceFormatter;

public class ReplicationFileSequenceFormatter {
    private ReplicationSequenceFormatter sequenceFormatter;
    private File workingDirectory;

    public ReplicationFileSequenceFormatter(File workingDirectory) {
        this(workingDirectory, 9, 3);
    }

    public ReplicationFileSequenceFormatter(File workingDirectory, int minimumLength, int groupingLength) {
        this.workingDirectory = workingDirectory;
        this.sequenceFormatter = new ReplicationSequenceFormatter(minimumLength, groupingLength);
    }

    public File getFormattedName(long sequenceNumber, String fileNameSuffix) {
        String fileName = this.sequenceFormatter.getFormattedName(sequenceNumber, fileNameSuffix);
        StringTokenizer pathTokenizer = new StringTokenizer(fileName, "/");
        File formattedPath = this.workingDirectory;
        while (pathTokenizer.hasMoreTokens()) {
            formattedPath = new File(formattedPath, pathTokenizer.nextToken());
            if (!pathTokenizer.hasMoreTokens() || formattedPath.exists() || formattedPath.mkdir()) continue;
            throw new OsmosisRuntimeException("Unable to create directory \"" + formattedPath + "\".");
        }
        return formattedPath;
    }
}

