/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.v0_6.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class ReplicationState
extends org.openstreetmap.osmosis.replication.common.ReplicationState {
    private long txnMax;
    private long txnMaxQueried;
    private List<Long> txnActive;
    private List<Long> txnReady;

    public ReplicationState() {
        this.txnMax = 0L;
        this.txnMaxQueried = 0L;
        this.txnActive = new ArrayList<Long>();
        this.txnReady = new ArrayList<Long>();
    }

    public ReplicationState(long txnMax, long txnMaxQueried, List<Long> txnActive, List<Long> txnReady, Date timestamp, long sequenceNumber) {
        super(timestamp, sequenceNumber);
        this.txnMax = txnMax;
        this.txnMaxQueried = txnMaxQueried;
        this.txnActive = new ArrayList<Long>(txnActive);
        this.txnReady = new ArrayList<Long>(txnReady);
    }

    public ReplicationState(Map<String, String> properties) {
        this.load(properties);
    }

    public void load(Map<String, String> properties) {
        super.load(properties);
        this.txnMax = Long.parseLong(properties.get("txnMax"));
        this.txnMaxQueried = Long.parseLong(properties.get("txnMaxQueried"));
        this.txnActive = this.fromString(properties.get("txnActiveList"));
        this.txnReady = this.fromString(properties.get("txnReadyList"));
    }

    public void store(Map<String, String> properties) {
        super.store(properties);
        properties.put("txnMax", Long.toString(this.txnMax));
        properties.put("txnMaxQueried", Long.toString(this.txnMaxQueried));
        properties.put("txnActiveList", this.toString(this.txnActive));
        properties.put("txnReadyList", this.toString(this.txnReady));
    }

    public Map<String, String> store() {
        HashMap<String, String> properties = new HashMap<String, String>();
        this.store(properties);
        return properties;
    }

    private String toString(List<Long> values) {
        StringBuilder buffer = new StringBuilder();
        for (long value : values) {
            if (buffer.length() > 0) {
                buffer.append(',');
            }
            buffer.append(value);
        }
        return buffer.toString();
    }

    private List<Long> fromString(String values) {
        StringTokenizer tokens = new StringTokenizer(values, ",");
        ArrayList<Long> result = new ArrayList<Long>();
        while (tokens.hasMoreTokens()) {
            result.add(Long.parseLong(tokens.nextToken()));
        }
        return result;
    }

    public long getTxnMax() {
        return this.txnMax;
    }

    public void setTxnMax(long txnMax) {
        this.txnMax = txnMax;
    }

    public long getTxnMaxQueried() {
        return this.txnMaxQueried;
    }

    public void setTxnMaxQueried(long txnMaxQueried) {
        this.txnMaxQueried = txnMaxQueried;
    }

    public List<Long> getTxnActive() {
        return this.txnActive;
    }

    public List<Long> getTxnReady() {
        return this.txnReady;
    }

    public boolean equals(Object obj) {
        boolean result;
        if (obj instanceof ReplicationState) {
            ReplicationState compareState = (ReplicationState)((Object)obj);
            result = super.equals(obj) && this.txnMax == compareState.txnMax && this.txnMaxQueried == compareState.txnMaxQueried && ((Object)this.txnActive).equals(compareState.txnActive) && ((Object)this.txnReady).equals(compareState.txnReady);
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        return super.hashCode() + (int)this.txnMax + (int)this.txnMaxQueried;
    }

    public String toString() {
        return "ReplicationState(txnMax=" + this.txnMax + ", txnMaxQueried=" + this.txnMaxQueried + ", txnActive=" + this.txnActive + ", txnReady=" + this.txnReady + ", timestamp=" + this.getTimestamp() + ", sequenceNumber=" + this.getSequenceNumber() + ")";
    }
}

