/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.v0_6;

import java.util.Collections;
import java.util.Date;
import org.openstreetmap.osmosis.apidb.common.DatabaseContext2;
import org.openstreetmap.osmosis.apidb.v0_6.ApidbVersionConstants;
import org.openstreetmap.osmosis.apidb.v0_6.impl.AllEntityDao;
import org.openstreetmap.osmosis.apidb.v0_6.impl.EntitySnapshotReader;
import org.openstreetmap.osmosis.apidb.v0_6.impl.SchemaVersionValidator;
import org.openstreetmap.osmosis.core.container.v0_6.BoundContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;
import org.openstreetmap.osmosis.core.database.DatabasePreferences;
import org.openstreetmap.osmosis.core.domain.v0_6.Bound;
import org.openstreetmap.osmosis.core.task.v0_6.RunnableSource;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class ApidbReader
implements RunnableSource {
    private Sink sink;
    private DatabaseLoginCredentials loginCredentials;
    private DatabasePreferences preferences;
    private Date snapshotInstant;

    public ApidbReader(DatabaseLoginCredentials loginCredentials, DatabasePreferences preferences, Date snapshotInstant) {
        this.loginCredentials = loginCredentials;
        this.preferences = preferences;
        this.snapshotInstant = snapshotInstant;
    }

    public void setSink(Sink sink) {
        this.sink = sink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runImpl(DatabaseContext2 dbCtx) {
        try {
            this.sink.initialize(Collections.emptyMap());
            new SchemaVersionValidator(this.loginCredentials, this.preferences).validateVersion(ApidbVersionConstants.SCHEMA_MIGRATIONS);
            AllEntityDao entityDao = new AllEntityDao(dbCtx.getJdbcTemplate());
            this.sink.process((EntityContainer)new BoundContainer(new Bound("Osmosis 0.42-9-g7bd23cc-SNAPSHOT")));
            EntitySnapshotReader reader = new EntitySnapshotReader(entityDao.getHistory(), this.snapshotInstant);
            try {
                while (reader.hasNext()) {
                    this.sink.process((EntityContainer)reader.next());
                }
            }
            finally {
                reader.release();
            }
            this.sink.complete();
        }
        finally {
            this.sink.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        final DatabaseContext2 dbCtx = new DatabaseContext2(this.loginCredentials);
        try {
            dbCtx.executeWithinTransaction(new TransactionCallbackWithoutResult(){
                private DatabaseContext2 dbCtxInner;
                {
                    this.dbCtxInner = dbCtx;
                }

                protected void doInTransactionWithoutResult(TransactionStatus arg0) {
                    ApidbReader.this.runImpl(this.dbCtxInner);
                }
            });
        }
        finally {
            dbCtx.release();
        }
    }
}

