/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.v0_6;

import java.util.Collections;
import java.util.Date;
import org.openstreetmap.osmosis.apidb.common.DatabaseContext2;
import org.openstreetmap.osmosis.apidb.v0_6.ApidbVersionConstants;
import org.openstreetmap.osmosis.apidb.v0_6.impl.AllEntityDao;
import org.openstreetmap.osmosis.apidb.v0_6.impl.DeltaToDiffReader;
import org.openstreetmap.osmosis.apidb.v0_6.impl.SchemaVersionValidator;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;
import org.openstreetmap.osmosis.core.database.DatabasePreferences;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSink;
import org.openstreetmap.osmosis.core.task.v0_6.RunnableChangeSource;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class ApidbChangeReader
implements RunnableChangeSource {
    private ChangeSink changeSink;
    private DatabaseLoginCredentials loginCredentials;
    private DatabasePreferences preferences;
    private Date intervalBegin;
    private Date intervalEnd;
    private boolean fullHistory;

    public ApidbChangeReader(DatabaseLoginCredentials loginCredentials, DatabasePreferences preferences, Date intervalBegin, Date intervalEnd, boolean fullHistory) {
        this.loginCredentials = loginCredentials;
        this.preferences = preferences;
        this.intervalBegin = intervalBegin;
        this.intervalEnd = intervalEnd;
        this.fullHistory = fullHistory;
    }

    public void setChangeSink(ChangeSink changeSink) {
        this.changeSink = changeSink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runImpl(DatabaseContext2 dbCtx) {
        try {
            this.changeSink.initialize(Collections.emptyMap());
            new SchemaVersionValidator(this.loginCredentials, this.preferences).validateVersion(ApidbVersionConstants.SCHEMA_MIGRATIONS);
            AllEntityDao entityDao = new AllEntityDao(dbCtx.getJdbcTemplate());
            DeltaToDiffReader reader = entityDao.getHistory(this.intervalBegin, this.intervalEnd);
            if (!this.fullHistory) {
                reader = new DeltaToDiffReader(reader);
            }
            try {
                while (reader.hasNext()) {
                    this.changeSink.process((ChangeContainer)reader.next());
                }
            }
            finally {
                reader.release();
            }
            this.changeSink.complete();
        }
        finally {
            this.changeSink.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        final DatabaseContext2 dbCtx = new DatabaseContext2(this.loginCredentials);
        try {
            dbCtx.executeWithinTransaction(new TransactionCallbackWithoutResult(){
                private DatabaseContext2 dbCtxInner;
                {
                    this.dbCtxInner = dbCtx;
                }

                protected void doInTransactionWithoutResult(TransactionStatus arg0) {
                    ApidbChangeReader.this.runImpl(this.dbCtxInner);
                }
            });
        }
        finally {
            dbCtx.release();
        }
    }
}

