/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.tagtransform.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.openstreetmap.osmosis.tagtransform.Matcher;
import org.openstreetmap.osmosis.tagtransform.Output;
import org.openstreetmap.osmosis.tagtransform.TTEntityType;
import org.openstreetmap.osmosis.tagtransform.Translation;
import org.openstreetmap.osmosis.tagtransform.impl.AndMatcher;
import org.openstreetmap.osmosis.tagtransform.impl.CopyAll;
import org.openstreetmap.osmosis.tagtransform.impl.CopyMatched;
import org.openstreetmap.osmosis.tagtransform.impl.CopyUnmatched;
import org.openstreetmap.osmosis.tagtransform.impl.NoTagMatcher;
import org.openstreetmap.osmosis.tagtransform.impl.OrMatcher;
import org.openstreetmap.osmosis.tagtransform.impl.TagMatcher;
import org.openstreetmap.osmosis.tagtransform.impl.TagOutput;
import org.openstreetmap.osmosis.tagtransform.impl.TransformLoadException;
import org.openstreetmap.osmosis.tagtransform.impl.TranslationImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TransformLoader {
    private static final Logger LOG = Logger.getLogger(TransformLoader.class.getName());

    public List<Translation> load(String configFile) {
        ArrayList<Translation> translations = new ArrayList<Translation>();
        File file = new File(configFile);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(file);
            NodeList translationElements = doc.getDocumentElement().getElementsByTagName("translation");
            for (int i = 0; i < translationElements.getLength(); ++i) {
                Translation t = this.parseTranslation((Element)translationElements.item(i));
                if (t == null) continue;
                translations.add(t);
            }
        }
        catch (Exception e) {
            throw new TransformLoadException("Failed to load transform", e);
        }
        return translations;
    }

    private Translation parseTranslation(Element element) {
        String name = "";
        String description = "";
        Matcher matcher = null;
        Matcher finder = null;
        ArrayList<Output> output = new ArrayList<Output>();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            Element child = (Element)children.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equals("name")) {
                name = child.getTextContent();
                continue;
            }
            if (nodeName.equals("description")) {
                description = child.getTextContent();
                continue;
            }
            if (nodeName.equals("match")) {
                matcher = this.parseMatcher(child);
                continue;
            }
            if (nodeName.equals("find")) {
                finder = this.parseMatcher(child);
                continue;
            }
            if (!nodeName.equals("output")) continue;
            NodeList outputs = child.getChildNodes();
            for (int j = 0; j < outputs.getLength(); ++j) {
                Output o;
                if (!(outputs.item(j) instanceof Element) || (o = this.parseOutput((Element)outputs.item(j))) == null) continue;
                output.add(o);
            }
        }
        if (matcher != null) {
            LOG.info("New translation: " + name);
            return new TranslationImpl(name, description, matcher, finder, output);
        }
        return null;
    }

    private Output parseOutput(Element child) {
        String name = child.getNodeName();
        if (name.equals("copy-all")) {
            return new CopyAll();
        }
        if (name.equals("copy-unmatched")) {
            return new CopyUnmatched();
        }
        if (name.equals("copy-matched")) {
            return new CopyMatched();
        }
        if (name.equals("tag")) {
            String k = child.getAttribute("k");
            String v = child.getAttribute("v");
            String m = child.getAttribute("from_match");
            return new TagOutput(k, v, m);
        }
        return null;
    }

    private Matcher parseMatcher(Element matcher) {
        String name = matcher.getNodeName();
        if (name.equals("match") || name.equals("find")) {
            String mode;
            NodeList children = matcher.getChildNodes();
            ArrayList<Matcher> matchers = new ArrayList<Matcher>();
            String uname = null;
            int uid = 0;
            for (int i = 0; i < children.getLength(); ++i) {
                Element child;
                Matcher m;
                if (!(children.item(i) instanceof Element) || (m = this.parseMatcher(child = (Element)children.item(i))) == null) continue;
                matchers.add(m);
            }
            TTEntityType type = this.getType(matcher.getAttribute("type"));
            if (matcher.getAttribute("user") != "") {
                uname = matcher.getAttribute("user");
            }
            if (matcher.getAttribute("uid") != "") {
                uid = Integer.parseInt(matcher.getAttribute("uid"));
            }
            if ((mode = name.equals("find") ? "or" : matcher.getAttribute("mode")) == null || mode.equals("") || mode.equals("and")) {
                return new AndMatcher(matchers, type, uname, uid);
            }
            if (mode.equals("or")) {
                return new OrMatcher(matchers, type, uname, uid);
            }
        } else {
            if (name.equals("tag")) {
                String k = matcher.getAttribute("k");
                String v = matcher.getAttribute("v");
                String id = matcher.getAttribute("match_id");
                return new TagMatcher(id, k, v);
            }
            if (name.equals("notag")) {
                String k = matcher.getAttribute("k");
                String v = matcher.getAttribute("v");
                return new NoTagMatcher(k, v);
            }
        }
        return null;
    }

    private TTEntityType getType(String type) {
        if (type == null || type.isEmpty() || type.equals("all")) {
            return null;
        }
        if (type.equals("node")) {
            return TTEntityType.NODE;
        }
        if (type.equals("way")) {
            return TTEntityType.WAY;
        }
        if (type.equals("relation")) {
            return TTEntityType.RELATION;
        }
        if (type.equals("bound")) {
            return TTEntityType.BOUND;
        }
        return null;
    }
}

