/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.v0_6.impl;

import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;

public class MemberTypeValueMapper {
    private static Map<EntityType, String> entityToMemberMap;
    private static Map<String, EntityType> memberToEntityMap;

    private static void addEntityTypeMapping(EntityType entityType, String memberType) {
        if (entityToMemberMap.containsKey(entityType)) {
            throw new OsmosisRuntimeException("Entity type (" + entityType + ") already has a mapping.");
        }
        entityToMemberMap.put(entityType, memberType);
        memberToEntityMap.put(memberType, entityType);
    }

    public String getMemberType(EntityType entityType) {
        if (entityToMemberMap.containsKey(entityType)) {
            return entityToMemberMap.get(entityType);
        }
        throw new OsmosisRuntimeException("The entity type " + entityType + " is not recognised.");
    }

    public EntityType getEntityType(String memberType) {
        if (memberToEntityMap.containsKey(memberType)) {
            return memberToEntityMap.get(memberType);
        }
        throw new OsmosisRuntimeException("The member type " + memberType + " is not recognised.");
    }

    static {
        EntityType[] entityTypes = EntityType.values();
        entityToMemberMap = new HashMap<EntityType, String>(entityTypes.length);
        memberToEntityMap = new HashMap<String, EntityType>(entityTypes.length);
        MemberTypeValueMapper.addEntityTypeMapping(EntityType.Bound, "B");
        MemberTypeValueMapper.addEntityTypeMapping(EntityType.Node, "N");
        MemberTypeValueMapper.addEntityTypeMapping(EntityType.Way, "W");
        MemberTypeValueMapper.addEntityTypeMapping(EntityType.Relation, "R");
    }
}

