/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.v0_6.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.database.DbFeature;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.store.Storeable;
import org.openstreetmap.osmosis.pgsimple.common.BaseDao;
import org.openstreetmap.osmosis.pgsimple.common.DatabaseContext;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.EntityFeatureMapper;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.EntityFeatureTableReader;

public class EntityFeatureDao<Tef extends Storeable, Tdb extends DbFeature<Tef>>
extends BaseDao {
    private static final Logger LOG = Logger.getLogger(EntityFeatureDao.class.getName());
    protected EntityFeatureMapper<Tdb> entityFeatureBuilder;
    private PreparedStatement getStatement;
    private PreparedStatement insertStatement;
    private PreparedStatement deleteStatement;

    protected EntityFeatureDao(DatabaseContext dbCtx, EntityFeatureMapper<Tdb> entityFeatureBuilder) {
        super(dbCtx);
        this.entityFeatureBuilder = entityFeatureBuilder;
    }

    public Collection<Tdb> getAll(long entityId) {
        ResultSet resultSet = null;
        if (this.getStatement == null) {
            this.getStatement = this.prepareStatement(this.entityFeatureBuilder.getSqlSelect(true, true));
        }
        try {
            this.getStatement.setLong(1, entityId);
            resultSet = this.getStatement.executeQuery();
            ArrayList<Tdb> resultList = new ArrayList<Tdb>();
            while (resultSet.next()) {
                resultList.add(this.entityFeatureBuilder.buildEntity(resultSet));
            }
            resultSet.close();
            resultSet = null;
            ArrayList<Tdb> arrayList = resultList;
            return arrayList;
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Query failed for " + this.entityFeatureBuilder.getEntityName() + " " + entityId + ".", (Throwable)e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    LOG.log(Level.WARNING, "Unable to close result set.", e);
                }
            }
        }
    }

    public Collection<Tef> getAllRaw(long entityId) {
        Collection<Tdb> dbFeatures = this.getAll(entityId);
        ArrayList<Storeable> rawFeatures = new ArrayList<Storeable>(dbFeatures.size());
        for (DbFeature dbFeature : dbFeatures) {
            rawFeatures.add(dbFeature.getFeature());
        }
        return rawFeatures;
    }

    public void addAll(Collection<Tdb> features) {
        if (this.insertStatement == null) {
            this.insertStatement = this.prepareStatement(this.entityFeatureBuilder.getSqlInsert(1));
        }
        for (DbFeature feature : features) {
            try {
                this.entityFeatureBuilder.populateEntityParameters(this.insertStatement, 1, feature);
                this.insertStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Insert failed for " + this.entityFeatureBuilder.getEntityName() + " " + feature.getEntityId() + ".");
            }
        }
    }

    public void removeList(long entityId) {
        if (this.deleteStatement == null) {
            this.deleteStatement = this.prepareStatement(this.entityFeatureBuilder.getSqlDelete(true));
        }
        try {
            int prmIndex = 1;
            this.deleteStatement.setLong(prmIndex++, entityId);
            this.deleteStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Delete failed for " + this.entityFeatureBuilder.getEntityName() + " " + entityId + ".");
        }
    }

    public ReleasableIterator<Tdb> iterate() {
        return new EntityFeatureTableReader(this.getDatabaseContext(), this.entityFeatureBuilder);
    }
}

