/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replicationhttp.v0_6.impl;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSink;
import org.openstreetmap.osmosis.core.util.PropertiesPersister;
import org.openstreetmap.osmosis.replication.common.ReplicationState;
import org.openstreetmap.osmosis.replicationhttp.v0_6.impl.ChunkedDataReceiver;
import org.openstreetmap.osmosis.replicationhttp.v0_6.impl.SequenceClientControl;
import org.openstreetmap.osmosis.replicationhttp.v0_6.impl.SequenceClientHandler;
import org.openstreetmap.osmosis.xml.common.CompressionMethod;
import org.openstreetmap.osmosis.xml.v0_6.XmlChangeReader;

public class ReplicationDataClientHandler
extends SequenceClientHandler {
    private static final Logger LOG = Logger.getLogger(ReplicationDataClientHandler.class.getName());
    private ChangeSink changeSink;
    private String pathPrefix;
    private NoLifecycleChangeSinkWrapper noLifecycleChangeSink;
    private boolean sinkInitInvoked;
    private boolean replicationStateReceived;
    private ReplicationState replicationState;
    private ChunkedDataReceiver chunkReceiver;

    public ReplicationDataClientHandler(SequenceClientControl control, ChangeSink changeSink, String serverHost, String pathPrefix) {
        super(control, serverHost);
        this.changeSink = changeSink;
        this.pathPrefix = pathPrefix;
        this.noLifecycleChangeSink = new NoLifecycleChangeSinkWrapper(changeSink);
        this.sinkInitInvoked = false;
        this.replicationStateReceived = false;
        this.replicationState = null;
        this.chunkReceiver = new ChunkedDataReceiver();
    }

    private void sendReplicationData(File chunkFile) {
        this.replicationState = null;
        this.replicationStateReceived = false;
        this.sinkInitInvoked = false;
        if (chunkFile != null) {
            XmlChangeReader changeReader = new XmlChangeReader(chunkFile, true, CompressionMethod.GZip);
            changeReader.setChangeSink((ChangeSink)this.noLifecycleChangeSink);
            changeReader.run();
        }
        this.changeSink.complete();
    }

    private void invokeSinkInit() {
        this.replicationState = new ReplicationState();
        HashMap<String, ReplicationState> metaData = new HashMap<String, ReplicationState>(1);
        metaData.put("replication.state", this.replicationState);
        this.changeSink.initialize(metaData);
        this.sinkInitInvoked = true;
    }

    @Override
    protected String getRequestUri() {
        this.invokeSinkInit();
        long requestSequenceNumber = this.replicationState.getSequenceNumber();
        return this.pathPrefix + "/replicationData/" + requestSequenceNumber + "/tail";
    }

    private ReplicationState loadState(File stateFile) {
        PropertiesPersister persister = new PropertiesPersister(stateFile);
        ReplicationState state = new ReplicationState();
        state.load(persister.loadMap());
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processMessageData(ChannelBuffer buffer) {
        List<File> chunkFiles = this.chunkReceiver.processData(buffer);
        try {
            for (File chunkFile : chunkFiles) {
                if (!this.replicationStateReceived) {
                    if (!this.sinkInitInvoked) {
                        this.invokeSinkInit();
                    }
                    ReplicationState serverReplicationState = this.loadState(chunkFile);
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer("Received replication state " + serverReplicationState.getSequenceNumber());
                    }
                    if (serverReplicationState.getSequenceNumber() != this.replicationState.getSequenceNumber()) {
                        throw new OsmosisRuntimeException("Received sequence number " + serverReplicationState.getSequenceNumber() + " from server, expected " + this.replicationState.getSequenceNumber());
                    }
                    this.replicationState.setTimestamp(serverReplicationState.getTimestamp());
                    this.replicationStateReceived = true;
                    if (this.replicationState.getSequenceNumber() != 0L) continue;
                    this.sendReplicationData(null);
                    continue;
                }
                this.sendReplicationData(chunkFile);
            }
        }
        finally {
            for (File chunkFile : chunkFiles) {
                if (chunkFile.delete()) continue;
                LOG.log(Level.WARNING, "Unable to delete the current temporary chunk file " + chunkFile);
            }
        }
    }

    @Override
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.chunkReceiver.release();
        super.channelClosed(ctx, e);
    }

    private static class NoLifecycleChangeSinkWrapper
    implements ChangeSink {
        private ChangeSink changeSink;

        public NoLifecycleChangeSinkWrapper(ChangeSink changeSink) {
            this.changeSink = changeSink;
        }

        public void initialize(Map<String, Object> metaData) {
        }

        public void process(ChangeContainer change) {
            this.changeSink.process(change);
        }

        public void complete() {
        }

        public void release() {
        }
    }
}

