/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replicationhttp.v0_6.impl;

import java.nio.channels.ClosedChannelException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.replicationhttp.v0_6.impl.SequenceClientControl;

public abstract class SequenceClientHandler
extends SimpleChannelHandler {
    private static final Logger LOG = Logger.getLogger(SequenceClientHandler.class.getName());
    private SequenceClientControl control;
    private String serverHost;
    private boolean midStream;
    private boolean active;

    public SequenceClientHandler(SequenceClientControl control, String serverHost) {
        this.control = control;
        this.serverHost = serverHost;
        this.active = true;
    }

    protected abstract String getRequestUri();

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, this.getRequestUri());
        request.addHeader("Host", (Object)this.serverHost);
        Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)e.getFuture(), (Object)request);
        this.midStream = false;
    }

    protected abstract void processMessageData(ChannelBuffer var1);

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (this.active) {
            ChannelBuffer buffer;
            if (!this.midStream) {
                HttpResponse response = (HttpResponse)e.getMessage();
                HttpResponseStatus status = response.getStatus();
                if (!HttpResponseStatus.OK.equals((Object)status)) {
                    throw new OsmosisRuntimeException("Received a " + status + " response from the server.");
                }
                buffer = response.getContent();
                this.midStream = true;
            } else {
                HttpChunk chunk = (HttpChunk)e.getMessage();
                buffer = chunk.getContent();
            }
            if (buffer.readableBytes() > 0) {
                this.processMessageData(buffer);
            }
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.control.channelClosed();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        this.active = false;
        Throwable t = e.getCause();
        if (!(t instanceof ClosedChannelException)) {
            LOG.log(Level.SEVERE, "Error during processing for channel " + ctx.getChannel() + ".", t);
        }
        e.getChannel().close();
    }
}

