/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.v0_6.impl;

import java.io.Writer;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.task.common.ChangeAction;
import org.openstreetmap.osmosis.xml.common.ElementWriter;
import org.openstreetmap.osmosis.xml.v0_6.impl.OsmWriter;

public class OsmChangeWriter
extends ElementWriter {
    private OsmWriter osmCreateWriter;
    private OsmWriter osmModifyWriter;
    private OsmWriter osmDeleteWriter;
    private OsmWriter activeOsmWriter;
    private ChangeAction lastAction;

    public OsmChangeWriter() {
        this("osmChange", 0);
    }

    public OsmChangeWriter(String elementName, int indentLevel) {
        super(elementName, indentLevel);
        this.osmCreateWriter = new OsmWriter("create", indentLevel + 1, false, false);
        this.osmModifyWriter = new OsmWriter("modify", indentLevel + 1, false, false);
        this.osmDeleteWriter = new OsmWriter("delete", indentLevel + 1, false, false);
        this.activeOsmWriter = null;
        this.lastAction = null;
    }

    @Override
    public void setWriter(Writer aWriter) {
        super.setWriter(aWriter);
        this.osmCreateWriter.setWriter(aWriter);
        this.osmModifyWriter.setWriter(aWriter);
        this.osmDeleteWriter.setWriter(aWriter);
    }

    public void begin() {
        this.beginOpenElement();
        this.addAttribute("version", "0.6");
        this.addAttribute("generator", "Osmosis 0.42-9-g7bd23cc-SNAPSHOT");
        this.endOpenElement(false);
    }

    public void end() {
        if (this.activeOsmWriter != null) {
            this.activeOsmWriter.end();
            this.activeOsmWriter = null;
        }
        this.lastAction = null;
        this.closeElement();
    }

    private OsmWriter getWriterForAction(ChangeAction action) {
        if (action.equals((Object)ChangeAction.Create)) {
            return this.osmCreateWriter;
        }
        if (action.equals((Object)ChangeAction.Modify)) {
            return this.osmModifyWriter;
        }
        if (action.equals((Object)ChangeAction.Delete)) {
            return this.osmDeleteWriter;
        }
        throw new OsmosisRuntimeException("The change action " + action + " is not recognised.");
    }

    private void updateActiveOsmWriter(ChangeAction action) {
        if (action != this.lastAction) {
            if (this.activeOsmWriter != null) {
                this.activeOsmWriter.end();
            }
            this.activeOsmWriter = this.getWriterForAction(action);
            this.activeOsmWriter.begin();
            this.lastAction = action;
        }
    }

    public void process(ChangeContainer changeContainer) {
        this.updateActiveOsmWriter(changeContainer.getAction());
        this.activeOsmWriter.process(changeContainer.getEntityContainer());
    }
}

