/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replication.common;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.time.DateFormatter;
import org.openstreetmap.osmosis.core.time.DateParser;

public class TimestampTracker {
    private static final Logger LOG = Logger.getLogger(TimestampTracker.class.getName());
    private File timestampFile;
    private File newTimestampFile;
    private DateParser dateParser;
    private DateFormatter dateFormatter;

    public TimestampTracker(File timestampFile, File newTimestampFile) {
        this.timestampFile = timestampFile;
        this.newTimestampFile = newTimestampFile;
        this.dateParser = new DateParser();
        this.dateFormatter = new DateFormatter();
    }

    private void renameNewFileToCurrent() {
        if (!this.newTimestampFile.exists()) {
            throw new OsmosisRuntimeException("Can't rename non-existent file " + this.newTimestampFile + ".");
        }
        if (this.timestampFile.exists() && !this.timestampFile.delete()) {
            throw new OsmosisRuntimeException("Unable to delete file " + this.timestampFile + ".");
        }
        if (!this.newTimestampFile.renameTo(this.timestampFile)) {
            throw new OsmosisRuntimeException("Unable to rename file " + this.newTimestampFile + " to " + this.timestampFile + ".");
        }
    }

    public Date getTime() {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(this.timestampFile);
            BufferedReader reader = new BufferedReader(fileReader);
            Date result = this.dateParser.parse(reader.readLine());
            fileReader.close();
            fileReader = null;
            Date date = result;
            return date;
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to read the time from file " + this.timestampFile + ".", (Throwable)e);
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Unable to close time file " + this.timestampFile + ".", e);
                }
            }
        }
    }

    public void setTime(Date time) {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(this.newTimestampFile);
            BufferedWriter writer = new BufferedWriter(fileWriter);
            writer.write(this.dateFormatter.format(time));
            writer.close();
            this.renameNewFileToCurrent();
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to write the time to temporary file " + this.newTimestampFile + ".", (Throwable)e);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Unable to close temporary time file " + this.newTimestampFile + ".", e);
                }
            }
        }
    }
}

