/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.v0_6;

import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityProcessor;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;
import org.openstreetmap.osmosis.core.database.DatabasePreferences;
import org.openstreetmap.osmosis.core.task.common.ChangeAction;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSink;
import org.openstreetmap.osmosis.pgsnapshot.common.DatabaseContext;
import org.openstreetmap.osmosis.pgsnapshot.common.SchemaVersionValidator;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.ActionChangeWriter;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.ChangeWriter;

public class PostgreSqlChangeWriter
implements ChangeSink {
    private ChangeWriter changeWriter;
    private Map<ChangeAction, ActionChangeWriter> actionWriterMap;
    private DatabaseContext dbCtx;
    private SchemaVersionValidator schemaVersionValidator;
    private boolean initialized;

    public PostgreSqlChangeWriter(DatabaseLoginCredentials loginCredentials, DatabasePreferences preferences, boolean keepInvalidWays) {
        this.dbCtx = new DatabaseContext(loginCredentials);
        this.changeWriter = new ChangeWriter(this.dbCtx);
        this.actionWriterMap = new HashMap<ChangeAction, ActionChangeWriter>();
        this.actionWriterMap.put(ChangeAction.Create, new ActionChangeWriter(this.changeWriter, ChangeAction.Create, keepInvalidWays));
        this.actionWriterMap.put(ChangeAction.Modify, new ActionChangeWriter(this.changeWriter, ChangeAction.Modify, keepInvalidWays));
        this.actionWriterMap.put(ChangeAction.Delete, new ActionChangeWriter(this.changeWriter, ChangeAction.Delete, keepInvalidWays));
        this.schemaVersionValidator = new SchemaVersionValidator(this.dbCtx.getJdbcTemplate(), preferences);
        this.initialized = false;
    }

    private void initialize() {
        if (!this.initialized) {
            this.dbCtx.beginTransaction();
            this.initialized = true;
        }
    }

    public void initialize(Map<String, Object> metaData) {
    }

    public void process(ChangeContainer change) {
        this.initialize();
        this.schemaVersionValidator.validateVersion(6);
        ChangeAction action = change.getAction();
        if (!this.actionWriterMap.containsKey(action)) {
            throw new OsmosisRuntimeException("The action " + action + " is unrecognized.");
        }
        change.getEntityContainer().process((EntityProcessor)this.actionWriterMap.get(action));
    }

    public void complete() {
        this.initialize();
        this.changeWriter.complete();
        this.dbCtx.commitTransaction();
    }

    public void release() {
        this.changeWriter.release();
        this.dbCtx.release();
    }
}

