/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.tagtransform.impl;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import org.openstreetmap.osmosis.tagtransform.Match;
import org.openstreetmap.osmosis.tagtransform.Output;

public class TagOutput
implements Output {
    private MessageFormat keyFormat;
    private MessageFormat valueFormat;
    private String fromMatch;

    public TagOutput(String key, String value, String fromMatch) {
        this.keyFormat = new MessageFormat(this.santitise(key));
        this.valueFormat = new MessageFormat(this.santitise(value));
        if (fromMatch != null && fromMatch.length() > 0) {
            this.fromMatch = fromMatch;
        }
    }

    private String santitise(String str) {
        if (str == null || str.length() == 0) {
            return "{0}";
        }
        return str;
    }

    @Override
    public void apply(Map<String, String> originalTags, Map<String, String> tags, Collection<Match> matches) {
        if (this.fromMatch != null) {
            for (Match match : matches) {
                String matchID = match.getMatchID();
                if (matchID == null || !matchID.equals(this.fromMatch)) continue;
                String[] args = new String[match.getKeyGroupCount()];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = match.getKey(i);
                }
                String key = this.keyFormat.format(args);
                args = new String[match.getValueGroupCount()];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = match.getValue(i);
                }
                String value = this.valueFormat.format(args);
                tags.put(key, value);
            }
        } else {
            tags.put(this.keyFormat.format(null), this.valueFormat.format(null));
        }
    }
}

