/*
 * Decompiled with CFR 0.152.
 */
package org.postgis.binary;

public abstract class ByteGetter {
    public abstract int get(int var1);

    public static class StringByteGetter
    extends ByteGetter {
        private String rep;

        public StringByteGetter(String rep) {
            this.rep = rep;
        }

        public int get(int index) {
            byte high = StringByteGetter.unhex(this.rep.charAt(index *= 2));
            byte low = StringByteGetter.unhex(this.rep.charAt(index + 1));
            return (high << 4) + low;
        }

        public static byte unhex(char c) {
            if (c >= '0' && c <= '9') {
                return (byte)(c - 48);
            }
            if (c >= 'A' && c <= 'F') {
                return (byte)(c - 65 + 10);
            }
            if (c >= 'a' && c <= 'f') {
                return (byte)(c - 97 + 10);
            }
            throw new IllegalArgumentException("No valid Hex char " + c);
        }
    }

    public static class BinaryByteGetter
    extends ByteGetter {
        private byte[] array;

        public BinaryByteGetter(byte[] array) {
            this.array = array;
        }

        public int get(int index) {
            return this.array[index] & 0xFF;
        }
    }
}

