/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.common;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.pgsimple.common.DatabaseContext;

public abstract class BaseTableReader<T>
implements ReleasableIterator<T> {
    private static final Logger LOG = Logger.getLogger(BaseTableReader.class.getName());
    private DatabaseContext dbCtx;
    private ResultSet resultSet;
    private T nextValue;

    public BaseTableReader(DatabaseContext dbCtx) {
        this.dbCtx = dbCtx;
    }

    protected abstract ResultSet createResultSet(DatabaseContext var1);

    protected abstract ReadResult<T> createNextValue(ResultSet var1);

    protected ReadResult<T> createLastValue() {
        return new ReadResult<Object>(true, null);
    }

    private void readNextValue() {
        if (this.resultSet == null) {
            this.resultSet = this.createResultSet(this.dbCtx);
        }
        try {
            ReadResult<T> readResult;
            while (!(readResult = this.resultSet.next() ? this.createNextValue(this.resultSet) : this.createLastValue()).isUsableResult()) {
            }
            this.nextValue = readResult.getEntity();
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to move to next record.", (Throwable)e);
        }
    }

    public boolean hasNext() {
        if (this.resultSet == null) {
            this.readNextValue();
        }
        return this.nextValue != null;
    }

    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T result = this.nextValue;
        this.readNextValue();
        return result;
    }

    public void release() {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException e) {
                LOG.log(Level.WARNING, "Unable to close result set.", e);
            }
            this.resultSet = null;
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected static class ReadResult<T> {
        private boolean usableResult;
        private T entity;

        public ReadResult(boolean usableResult, T entity) {
            this.usableResult = usableResult;
            this.entity = entity;
        }

        public boolean isUsableResult() {
            return this.usableResult;
        }

        public T getEntity() {
            return this.entity;
        }
    }
}

