/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replication.v0_6;

import java.io.File;
import java.util.Date;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.task.common.RunnableTask;
import org.openstreetmap.osmosis.core.util.FileBasedLock;
import org.openstreetmap.osmosis.core.util.ResourceFileManager;
import org.openstreetmap.osmosis.replication.common.TimestampTracker;

public class IntervalDownloaderInitializer
implements RunnableTask {
    private static final String LOCK_FILE_NAME = "download.lock";
    private static final String CONFIG_FILE_NAME = "configuration.txt";
    private static final String TSTAMP_FILE_NAME = "timestamp.txt";
    private static final String TSTAMP_NEW_FILE_NAME = "timestamp-new.txt";
    private static final String CONFIG_RESOURCE = "impl/intervalConfiguration.txt";
    private File workingDirectory;
    private Date initialDate;

    public IntervalDownloaderInitializer(File workingDirectory, Date initialDate) {
        this.workingDirectory = workingDirectory;
        this.initialDate = initialDate;
    }

    private void initializeDirectory() {
        ResourceFileManager resourceFileManager = new ResourceFileManager();
        File configFile = new File(this.workingDirectory, CONFIG_FILE_NAME);
        File timestampFile = new File(this.workingDirectory, TSTAMP_FILE_NAME);
        File newTimestampFile = new File(this.workingDirectory, TSTAMP_NEW_FILE_NAME);
        if (configFile.exists()) {
            throw new OsmosisRuntimeException("Config file configuration.txt already exists.");
        }
        resourceFileManager.copyResourceToFile(this.getClass(), CONFIG_RESOURCE, configFile);
        if (timestampFile.exists()) {
            throw new OsmosisRuntimeException("Timestamp file timestamp.txt already exists.");
        }
        new TimestampTracker(timestampFile, newTimestampFile).setTime(this.initialDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        FileBasedLock fileLock = new FileBasedLock(new File(this.workingDirectory, LOCK_FILE_NAME));
        try {
            fileLock.lock();
            this.initializeDirectory();
            fileLock.unlock();
        }
        finally {
            fileLock.release();
        }
    }
}

