/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.store;

import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;

public class PeekableIterator<T>
implements ReleasableIterator<T> {
    private ReleasableIterator<T> sourceIterator;
    private T nextValue;
    private boolean nextValueAvailable;

    public PeekableIterator(ReleasableIterator<T> sourceIterator) {
        this.sourceIterator = sourceIterator;
        this.nextValue = null;
        this.nextValueAvailable = false;
    }

    @Override
    public boolean hasNext() {
        return this.nextValueAvailable || this.sourceIterator.hasNext();
    }

    public T peekNext() {
        if (!this.nextValueAvailable) {
            this.nextValue = this.sourceIterator.next();
            this.nextValueAvailable = true;
        }
        return this.nextValue;
    }

    @Override
    public T next() {
        T result = this.peekNext();
        this.nextValue = null;
        this.nextValueAvailable = false;
        return result;
    }

    @Override
    public void release() {
        this.sourceIterator.release();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

