/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.store;

import org.openstreetmap.osmosis.core.store.ObjectWriter;
import org.openstreetmap.osmosis.core.store.StoreClassRegister;
import org.openstreetmap.osmosis.core.store.StoreWriter;
import org.openstreetmap.osmosis.core.store.Storeable;
import org.openstreetmap.osmosis.core.store.StoreableConstructorCache;

public abstract class BaseObjectWriter
implements ObjectWriter {
    private StoreWriter storeWriter;
    private StoreClassRegister storeClassRegister;
    private StoreableConstructorCache constructorCache;

    protected BaseObjectWriter(StoreWriter storeWriter, StoreClassRegister storeClassRegister) {
        this.storeWriter = storeWriter;
        this.storeClassRegister = storeClassRegister;
        this.constructorCache = new StoreableConstructorCache();
    }

    protected abstract void writeClassIdentifier(StoreWriter var1, StoreClassRegister var2, Class<?> var3);

    @Override
    public void writeObject(Storeable value) {
        Class<?> clazz = value.getClass();
        this.constructorCache.getStoreableConstructor(clazz);
        this.writeClassIdentifier(this.storeWriter, this.storeClassRegister, clazz);
        value.store(this.storeWriter, this.storeClassRegister);
    }
}

