/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replication.v0_6;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.task.common.RunnableTask;
import org.openstreetmap.osmosis.core.util.FileBasedLock;
import org.openstreetmap.osmosis.core.util.PropertiesPersister;
import org.openstreetmap.osmosis.replication.common.ReplicationSequenceFormatter;
import org.openstreetmap.osmosis.replication.common.ReplicationState;
import org.openstreetmap.osmosis.replication.common.ServerStateReader;
import org.openstreetmap.osmosis.replication.v0_6.impl.ReplicationDownloaderConfiguration;
import org.openstreetmap.osmosis.xml.common.CompressionMethod;
import org.openstreetmap.osmosis.xml.v0_6.XmlChangeReader;

public abstract class BaseReplicationDownloader
implements RunnableTask {
    private static final Logger LOG = Logger.getLogger(BaseReplicationDownloader.class.getName());
    private static final String LOCK_FILE = "download.lock";
    private static final String CONFIG_FILE = "configuration.txt";
    private static final String LOCAL_STATE_FILE = "state.txt";
    private File workingDirectory;
    private ReplicationSequenceFormatter sequenceFormatter;
    private ServerStateReader serverStateReader;

    public BaseReplicationDownloader(File workingDirectory) {
        this.workingDirectory = workingDirectory;
        this.sequenceFormatter = new ReplicationSequenceFormatter(9, 3);
        this.serverStateReader = new ServerStateReader();
    }

    protected File getWorkingDirectory() {
        return this.workingDirectory;
    }

    private File downloadReplicationFile(String fileName, URL baseUrl) {
        URL changesetUrl;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            changesetUrl = new URL(baseUrl, fileName);
        }
        catch (MalformedURLException e) {
            throw new OsmosisRuntimeException("The server file URL could not be created.", (Throwable)e);
        }
        try {
            URLConnection connection = changesetUrl.openConnection();
            connection.setReadTimeout(900000);
            connection.setConnectTimeout(900000);
            inputStream = connection.getInputStream();
            BufferedInputStream source = new BufferedInputStream(inputStream, 65536);
            File outputFile = File.createTempFile("change", null);
            outputStream = new FileOutputStream(outputFile);
            BufferedOutputStream sink = new BufferedOutputStream(outputStream, 65536);
            byte[] buffer = new byte[65536];
            int bytesRead = source.read(buffer);
            while (bytesRead > 0) {
                sink.write(buffer, 0, bytesRead);
                bytesRead = source.read(buffer);
            }
            sink.flush();
            inputStream.close();
            inputStream = null;
            outputStream.close();
            outputStream = null;
            File file = outputFile;
            return file;
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to read the changeset file " + fileName + " from the server.", (Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Unable to changeset download stream.", e);
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Unable to changeset output stream.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processReplicationFile(File replicationFile, ReplicationState replicationState) {
        try {
            XmlChangeReader xmlReader = new XmlChangeReader(replicationFile, true, CompressionMethod.GZip);
            this.processChangeset(xmlReader, replicationState);
        }
        finally {
            if (!replicationFile.delete()) {
                LOG.warning("Unable to delete file " + replicationFile.getName());
            }
        }
    }

    protected Date calculateMaximumTimestamp(ReplicationDownloaderConfiguration configuration, Date serverTimestamp, Date localTimestamp) {
        Date maximumTimestamp = serverTimestamp;
        if (configuration.getMaxInterval() > 0 && serverTimestamp.getTime() - localTimestamp.getTime() > (long)configuration.getMaxInterval()) {
            maximumTimestamp = new Date(localTimestamp.getTime() + (long)configuration.getMaxInterval());
        }
        LOG.finer("Maximum timestamp is " + maximumTimestamp);
        return maximumTimestamp;
    }

    private ReplicationState download(ReplicationDownloaderConfiguration configuration, ReplicationState serverState, ReplicationState initialLocalState) {
        ReplicationState localState = initialLocalState;
        URL baseUrl = configuration.getBaseUrl();
        Date maximumDownloadTimestamp = this.calculateMaximumTimestamp(configuration, serverState.getTimestamp(), localState.getTimestamp());
        LOG.fine("The maximum timestamp to be downloaded is " + maximumDownloadTimestamp + ".");
        while (localState.getSequenceNumber() < serverState.getSequenceNumber() && localState.getTimestamp().compareTo(maximumDownloadTimestamp) < 0) {
            long sequenceNumber = localState.getSequenceNumber() + 1L;
            LOG.finer("Processing replication sequence " + sequenceNumber + ".");
            ReplicationState fileReplicationState = this.serverStateReader.getServerState(baseUrl, sequenceNumber);
            if (fileReplicationState.getTimestamp().compareTo(maximumDownloadTimestamp) > 0 && localState.getSequenceNumber() != initialLocalState.getSequenceNumber()) break;
            File replicationFile = this.downloadReplicationFile(this.sequenceFormatter.getFormattedName(sequenceNumber, ".osc.gz"), baseUrl);
            this.processReplicationFile(replicationFile, fileReplicationState);
            localState = fileReplicationState;
        }
        return localState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runImpl() {
        try {
            ReplicationState localState;
            ReplicationDownloaderConfiguration configuration = new ReplicationDownloaderConfiguration(new File(this.workingDirectory, CONFIG_FILE));
            LOG.fine("Reading current server state.");
            ReplicationState serverState = this.serverStateReader.getServerState(configuration.getBaseUrl());
            PropertiesPersister localStatePersistor = new PropertiesPersister(new File(this.workingDirectory, LOCAL_STATE_FILE));
            this.processInitialize(Collections.<String, Object>emptyMap());
            if (localStatePersistor.exists()) {
                localState = new ReplicationState(localStatePersistor.loadMap());
                localState = this.download(configuration, serverState, localState);
            } else {
                localState = serverState;
                this.processInitializeState(localState);
            }
            this.processComplete();
            localStatePersistor.store(localState.store());
        }
        finally {
            this.processRelease();
        }
    }

    protected abstract void processInitialize(Map<String, Object> var1);

    protected abstract void processInitializeState(ReplicationState var1);

    protected abstract void processChangeset(XmlChangeReader var1, ReplicationState var2);

    protected abstract void processComplete();

    protected abstract void processRelease();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        FileBasedLock fileLock = new FileBasedLock(new File(this.workingDirectory, LOCK_FILE));
        try {
            fileLock.lock();
            this.runImpl();
            fileLock.unlock();
        }
        finally {
            fileLock.release();
        }
    }
}

