/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.dataset.v0_6.impl;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.container.v0_6.DatasetContext;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityManager;
import org.openstreetmap.osmosis.core.container.v0_6.NodeContainer;
import org.openstreetmap.osmosis.core.container.v0_6.NodeContainerIterator;
import org.openstreetmap.osmosis.core.container.v0_6.RelationContainer;
import org.openstreetmap.osmosis.core.container.v0_6.RelationContainerIterator;
import org.openstreetmap.osmosis.core.container.v0_6.WayContainer;
import org.openstreetmap.osmosis.core.container.v0_6.WayContainerIterator;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.core.filter.common.BitSetIdTracker;
import org.openstreetmap.osmosis.core.filter.common.IdTracker;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.store.EmptyIterator;
import org.openstreetmap.osmosis.core.store.MultipleSourceIterator;
import org.openstreetmap.osmosis.core.store.NoSuchIndexElementException;
import org.openstreetmap.osmosis.core.store.ReleasableAdaptorForIterator;
import org.openstreetmap.osmosis.core.store.UpcastIterator;
import org.openstreetmap.osmosis.dataset.v0_6.impl.BoundingBoxContext;
import org.openstreetmap.osmosis.dataset.v0_6.impl.NodeManager;
import org.openstreetmap.osmosis.dataset.v0_6.impl.NodeStorageContainer;
import org.openstreetmap.osmosis.dataset.v0_6.impl.RelationManager;
import org.openstreetmap.osmosis.dataset.v0_6.impl.RelationStorageContainer;
import org.openstreetmap.osmosis.dataset.v0_6.impl.RelationalIndexValueIdIterator;
import org.openstreetmap.osmosis.dataset.v0_6.impl.TileIndexValueIdIterator;
import org.openstreetmap.osmosis.dataset.v0_6.impl.WayManager;
import org.openstreetmap.osmosis.dataset.v0_6.impl.WayStorageContainer;

public class DatasetStoreReader
implements DatasetContext {
    private static final Logger LOG = Logger.getLogger(DatasetStoreReader.class.getName());
    private NodeStorageContainer nodeStorageContainer;
    private WayStorageContainer wayStorageContainer;
    private RelationStorageContainer relationStorageContainer;
    private NodeManager nodeManager;
    private WayManager wayManager;
    private RelationManager relationManager;
    private boolean enableWayTileIndex;

    public DatasetStoreReader(NodeStorageContainer nodeStorageContainer, WayStorageContainer wayStorageContainer, RelationStorageContainer relationStorageContainer, boolean enableWayTileIndex) {
        this.nodeStorageContainer = nodeStorageContainer;
        this.wayStorageContainer = wayStorageContainer;
        this.relationStorageContainer = relationStorageContainer;
        this.enableWayTileIndex = enableWayTileIndex;
        this.nodeManager = new NodeManager(nodeStorageContainer);
        this.wayManager = new WayManager(wayStorageContainer);
        this.relationManager = new RelationManager(relationStorageContainer);
    }

    private ReleasableIterator<Long> getNodeIdsForTileRange(int minimumTile, int maximumTile) {
        return new TileIndexValueIdIterator(this.nodeStorageContainer.getNodeTileIndexReader().getRange((Object)minimumTile, (Object)maximumTile));
    }

    private ReleasableIterator<Long> getWayIdsForTileRange(int minimumTile, int maximumTile) {
        return new ReleasableAdaptorForIterator(this.wayStorageContainer.getWayTileIndexReader().getRange(minimumTile, maximumTile));
    }

    private ReleasableIterator<Long> getWayIdsOwningNode(long nodeId) {
        return new RelationalIndexValueIdIterator(this.nodeStorageContainer.getNodeWayIndexReader().getRange((Object)nodeId, (Object)nodeId));
    }

    private ReleasableIterator<Long> getRelationIdsOwningNode(long nodeId) {
        return new RelationalIndexValueIdIterator(this.nodeStorageContainer.getNodeRelationIndexReader().getRange((Object)nodeId, (Object)nodeId));
    }

    private ReleasableIterator<Long> getRelationIdsOwningWay(long wayId) {
        return new RelationalIndexValueIdIterator(this.wayStorageContainer.getWayRelationIndexReader().getRange((Object)wayId, (Object)wayId));
    }

    private ReleasableIterator<Long> getRelationIdsOwningRelation(long relationId) {
        return new RelationalIndexValueIdIterator(this.relationStorageContainer.getRelationRelationIndexReader().getRange((Object)relationId, (Object)relationId));
    }

    private boolean isTileWayIndexAvailable() {
        return this.enableWayTileIndex;
    }

    @Deprecated
    public Node getNode(long id) {
        return this.nodeManager.getEntity(id);
    }

    @Deprecated
    public Way getWay(long id) {
        return this.wayManager.getEntity(id);
    }

    @Deprecated
    public Relation getRelation(long id) {
        return this.relationManager.getEntity(id);
    }

    public EntityManager<Node> getNodeManager() {
        return this.nodeManager;
    }

    public EntityManager<Way> getWayManager() {
        return this.wayManager;
    }

    public EntityManager<Relation> getRelationManager() {
        return this.relationManager;
    }

    public ReleasableIterator<EntityContainer> iterate() {
        ArrayList<UpcastIterator> sources = new ArrayList<UpcastIterator>();
        sources.add(new UpcastIterator((ReleasableIterator)new NodeContainerIterator(this.nodeManager.iterate())));
        sources.add(new UpcastIterator((ReleasableIterator)new WayContainerIterator(this.wayManager.iterate())));
        sources.add(new UpcastIterator((ReleasableIterator)new RelationContainerIterator(this.relationManager.iterate())));
        return new MultipleSourceIterator(sources);
    }

    private boolean isNodeInsideBox(Rectangle2D boundingBox, Node node) {
        return boundingBox.contains(node.getLongitude(), node.getLatitude());
    }

    private boolean isWayInsideBox(Rectangle2D boundingBox, List<Node> nodes) {
        for (Node node : nodes) {
            if (!this.isNodeInsideBox(boundingBox, node)) continue;
            return true;
        }
        for (int i = 0; i < nodes.size() - 1; ++i) {
            Node nodeA = nodes.get(i);
            Node nodeB = nodes.get(i + 1);
            if (!boundingBox.intersectsLine(nodeA.getLongitude(), nodeA.getLatitude(), nodeB.getLongitude(), nodeB.getLatitude())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateNodeIds(BoundingBoxContext bboxCtx) {
        BitSetIdTracker idTracker = new BitSetIdTracker();
        ReleasableIterator<Long> nodeIdsForTileset = this.getNodeIdsForTileRange(bboxCtx.minimumTile, bboxCtx.maximumTile);
        try {
            while (nodeIdsForTileset.hasNext()) {
                idTracker.set(((Long)nodeIdsForTileset.next()).longValue());
            }
        }
        finally {
            nodeIdsForTileset.release();
        }
        Iterator i$ = idTracker.iterator();
        while (i$.hasNext()) {
            long nodeId = (Long)i$.next();
            Node node = this.getNode(nodeId);
            if (!this.isNodeInsideBox(bboxCtx.boundingBox, node)) continue;
            bboxCtx.nodeIdTracker.set(nodeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateWayIdsUsingTileWayIndex(BoundingBoxContext bboxCtx, boolean completeWays) {
        ReleasableIterator<Long> tileWayIndexValues = this.getWayIdsForTileRange(bboxCtx.minimumTile, bboxCtx.maximumTile);
        try {
            while (tileWayIndexValues.hasNext()) {
                long wayId = (Long)tileWayIndexValues.next();
                Way way = this.getWay(wayId);
                ArrayList<Node> nodes = new ArrayList<Node>();
                for (WayNode wayNode : way.getWayNodes()) {
                    try {
                        nodes.add(this.getNode(wayNode.getNodeId()));
                    }
                    catch (NoSuchIndexElementException e) {
                        if (!LOG.isLoggable(Level.FINER)) continue;
                        LOG.finest("Ignoring referential integrity problem where way " + wayId + " refers to non-existent node " + wayNode.getNodeId() + ".");
                    }
                }
                if (!this.isWayInsideBox(bboxCtx.boundingBox, nodes)) continue;
                bboxCtx.wayIdTracker.set(wayId);
                if (!completeWays) continue;
                for (WayNode wayNode : way.getWayNodes()) {
                    long nodeId = wayNode.getNodeId();
                    if (bboxCtx.nodeIdTracker.get(nodeId)) continue;
                    bboxCtx.externalNodeIdTracker.set(nodeId);
                }
            }
        }
        finally {
            tileWayIndexValues.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateWayIdsUsingNodeWayIndex(BoundingBoxContext bboxCtx, boolean completeWays) {
        for (Long nodeId : bboxCtx.nodeIdTracker) {
            ReleasableIterator<Long> wayIdIterator = this.getWayIdsOwningNode(nodeId);
            try {
                while (wayIdIterator.hasNext()) {
                    bboxCtx.wayIdTracker.set(((Long)wayIdIterator.next()).longValue());
                }
            }
            finally {
                wayIdIterator.release();
            }
        }
        if (completeWays) {
            for (Long wayId : bboxCtx.wayIdTracker) {
                Way way = this.getWay(wayId);
                for (WayNode wayNode : way.getWayNodes()) {
                    long externalNodeId = wayNode.getNodeId();
                    if (bboxCtx.nodeIdTracker.get(externalNodeId)) continue;
                    bboxCtx.externalNodeIdTracker.set(externalNodeId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateRelationIds(BoundingBoxContext bboxCtx) {
        ReleasableIterator<Long> relationIdIterator;
        for (Long nodeId : bboxCtx.nodeIdTracker) {
            relationIdIterator = this.getRelationIdsOwningNode(nodeId);
            try {
                while (relationIdIterator.hasNext()) {
                    bboxCtx.relationIdTracker.set(((Long)relationIdIterator.next()).longValue());
                }
            }
            finally {
                relationIdIterator.release();
            }
        }
        for (Long wayId : bboxCtx.wayIdTracker) {
            relationIdIterator = this.getRelationIdsOwningWay(wayId);
            try {
                while (relationIdIterator.hasNext()) {
                    bboxCtx.relationIdTracker.set(((Long)relationIdIterator.next()).longValue());
                }
            }
            finally {
                relationIdIterator.release();
            }
        }
        boolean moreParents = true;
        while (moreParents) {
            moreParents = false;
            for (Long relationId : bboxCtx.relationIdTracker) {
                ReleasableIterator<Long> relationIdIterator2 = this.getRelationIdsOwningRelation(relationId);
                try {
                    while (relationIdIterator2.hasNext()) {
                        long parentRelationId = (Long)relationIdIterator2.next();
                        if (bboxCtx.relationIdTracker.get(parentRelationId)) continue;
                        bboxCtx.relationIdTracker.set(parentRelationId);
                        moreParents = true;
                    }
                }
                finally {
                    relationIdIterator2.release();
                }
            }
        }
    }

    public ReleasableIterator<EntityContainer> iterateBoundingBox(double left, double right, double top, double bottom, boolean completeWays) {
        LOG.fine("Beginning bounding box iteration.");
        BoundingBoxContext bboxCtx = new BoundingBoxContext(left, right, top, bottom);
        if (left > right || bottom > top) {
            LOG.fine("Bounding box is zero size, returning an empty iterator.");
            return new EmptyIterator();
        }
        LOG.fine("Populating node ids.");
        this.populateNodeIds(bboxCtx);
        if (this.isTileWayIndexAvailable()) {
            LOG.fine("Populating way ids using tile-way index.");
            this.populateWayIdsUsingTileWayIndex(bboxCtx, completeWays);
        } else {
            LOG.fine("Populating way ids using node-way index.");
            this.populateWayIdsUsingNodeWayIndex(bboxCtx, completeWays);
        }
        LOG.fine("Populating relation ids.");
        this.populateRelationIds(bboxCtx);
        bboxCtx.nodeIdTracker.setAll(bboxCtx.externalNodeIdTracker);
        LOG.fine("Iterating all entities matching result ids.");
        return new ResultIterator(bboxCtx.nodeIdTracker, bboxCtx.wayIdTracker, bboxCtx.relationIdTracker);
    }

    public void complete() {
    }

    public void release() {
        this.nodeStorageContainer.release();
        this.wayStorageContainer.release();
        this.relationStorageContainer.release();
    }

    private class ResultIterator
    implements ReleasableIterator<EntityContainer> {
        private Iterator<Long> nodeIds;
        private Iterator<Long> wayIds;
        private Iterator<Long> relationIds;

        public ResultIterator(IdTracker nodeIdList, IdTracker wayIdList, IdTracker relationIdList) {
            this.nodeIds = nodeIdList.iterator();
            this.wayIds = wayIdList.iterator();
            this.relationIds = relationIdList.iterator();
        }

        public boolean hasNext() {
            return this.nodeIds.hasNext() || this.wayIds.hasNext() || this.relationIds.hasNext();
        }

        public EntityContainer next() {
            if (this.nodeIds.hasNext()) {
                return new NodeContainer(DatasetStoreReader.this.getNode(this.nodeIds.next()));
            }
            if (this.wayIds.hasNext()) {
                return new WayContainer(DatasetStoreReader.this.getWay(this.wayIds.next()));
            }
            if (this.relationIds.hasNext()) {
                return new RelationContainer(DatasetStoreReader.this.getRelation(this.relationIds.next()));
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void release() {
        }
    }
}

